package org.simplextensions.configuration;

import java.net.URL;
import java.util.Collections;
import java.util.List;

import org.simplextensions.configuration.ExtensionsConfiguration.ClassNames;
import org.simplextensions.configuration.ExtensionsConfiguration.CreationPhaseListener;
import org.simplextensions.configuration.ExtensionsConfiguration.RegisterPhaseListener;
import org.simplextensions.configuration.ExtensionsConfiguration.ScanPhaseListeners;
import org.simplextensions.configuration.ExtensionsConfiguration.ValidatePhaseListener;

public class BundleConfiguration {

	private ExtensionsConfiguration extensionsConfiguration;

	ExtensionsConfiguration getExtensionsConfiguration() {
		return extensionsConfiguration;
	}

	public List<ScanPhaseListeners> getScanPhaseListeners() {
		return Collections.unmodifiableList(extensionsConfiguration.getScanPhaseListeners());
	}

	public List<ValidatePhaseListener> getValidatePhaseListener() {
		return Collections.unmodifiableList(extensionsConfiguration.getValidatePhaseListener());
	}

	public List<RegisterPhaseListener> getRegisterPhaseListener() {
		return Collections.unmodifiableList(extensionsConfiguration.getRegisterPhaseListener());
	}

	public List<CreationPhaseListener> getCreationPhaseListener() {
		return Collections.unmodifiableList(extensionsConfiguration.getCreationPhaseListener());
	}

	public List<String> getClassNames() {
		ClassNames classNames = this.extensionsConfiguration.getClassNames();
		if (classNames != null)
			return Collections.unmodifiableList(classNames.getClassName());
		else
			return null;
	}

	public String getName() {
		return this.extensionsConfiguration.getName();
	}

	private final URL url;

	public BundleConfiguration(ExtensionsConfiguration extensionsConfiguration, URL url) {
		super();
		this.extensionsConfiguration = extensionsConfiguration;
		this.url = url;
	}

	public URL getUrl() {
		return url;
	}

}
