package org.simplextensions.registry;

import org.simplextensions.di.annotations.Point;

public abstract class AService implements IService {

	private boolean started;

	@Point
	private IServiceRegistry serviceRegistry;

	public IServiceRegistry getServiceRegistry() {
		return serviceRegistry;
	}

	public AService() {
		super();
	}

	public synchronized boolean isStarted() {
		return started;
	}

	public synchronized void start() {
		this.started = true;
	}

	public synchronized void stop() {
		this.started = false;
	}

}