package org.simplextensions.registry;

public class ValidationStatus implements IValidationStatus {

	private final boolean valid;
	private final String message;

	public static IValidationStatus ok() {
		return new ValidationStatus(true, null);
	}

	public static IValidationStatus failed() {
		return new ValidationStatus(false, null);
	}

	public static IValidationStatus failed(String message) {
		return new ValidationStatus(false, message);
	}

	private ValidationStatus(boolean valid, String message) {
		this.valid = valid;
		this.message = message;
	}

	public boolean isValid() {
		return valid;
	}

	public String getMessage() {
		return message;
	}

}
