package org.simplextensions.registry.phaselisteners;

import javassist.bytecode.annotation.Annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.registry.Bundle;
import org.simplextensions.registry.EScanPhaseListener;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.PropertyValue;
import org.simplextensions.scanner.ClassScannerHelper;

/**
 * 
 * @author Mirek Szajowski m.szajowski@gmail.com
 * 
 */
public class DependencyLocatorScanPhaseListener extends EScanPhaseListener {

	private final static Log log = LogFactory.getLog(DependencyLocatorScanPhaseListener.class);

	public void scanClass(IExtensionRegistry extensionRegistry, Bundle bundle, String className, Annotation a) {
		log.trace("scanning service locator class: " + className);


		Class<?>[] annotations = ClassScannerHelper.getClassesValue(a, "value"); // fixed by: Andrzej Zietek
		for (Class<?> annotation : annotations) {
			String simpleClassName = className.substring(className.lastIndexOf('.') + 1);
			Extension extension = new Extension(extensionRegistry, bundle, className, simpleClassName+"_"+annotation.getSimpleName(),
					IDependencyLocator.EP_ID);

			extension.setPropertyValue(IDependencyLocator.ANNOTATION, new PropertyValue(annotation));

			extensionRegistry.addExtension(extension);
		}

	}
}
