package org.simplextensions.registry.phaselisteners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.ExtensionPoint;
import org.simplextensions.registry.IExtensionRegistry;

public class RegisterPhaseListener extends APhaseListener implements IRegisterPhaseListener {

	private final static Log log = LogFactory.getLog(RegisterPhaseListener.class);

	@Override
	public void processExtension(ExtensionEvent extensionEvent) {
		Extension extension = extensionEvent.getExtension();
		IExtensionRegistry extensionRegistry = extensionEvent.getExtensionRegistry();
		if (extension.isRegistered())
			return;
		ExtensionPoint extensionPoint = extensionRegistry.getExtensionPointMD(extension.getPointId());
		if (extensionPoint == null) {
			log.warn("extension point:"+extension.getPointId()+" of extension: " + extension.getId() + ", does not exists ");
			return;
		}
		log.info("registering extension: " + extension.getId() + " with extension point: " + extensionPoint.getId());
		extensionRegistry.registerExtension(extensionPoint, extension);
	}
}