package org.simplextensions.ui.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.simplextensions.ui.IApplicationWindow;
import org.simplextensions.ui.SWTApplicationWindow;

/**
 * 
 * 
 * @author Tomasz Krzy�ak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-17 10:11:43
 */
public class WindowMenuManager extends MenuManager {

	private final String menuId;
	private final SWTApplicationWindow applicationWindow;

	public WindowMenuManager(SWTApplicationWindow applicationWindow, String menuId) {
		super(applicationWindow.getExtensionRegistry());
		this.applicationWindow = applicationWindow;
		this.menuId = menuId;

		applicationWindow.getShell().setMenuBar(getMenuBar(applicationWindow.getShell()));
	}

	public IApplicationWindow getApplicationWindow() {
		return applicationWindow;
	}

	public Menu getMenuBar(Shell shell) {
		MenuExtensionMetadata menu = getMep().getMenu(menuId);
		Menu menuBar = new Menu(shell, SWT.BAR);

		for (MenuExtensionMetadata memd : menu.getSubItems()) {
			createSubMenu(menuBar, memd);
		}
		return menuBar;
	}

	protected void createMenuItems(Menu parentMenu, MenuExtensionMetadata submemd, IActions executable) {
		if (executable instanceof IApplicationWindowActions) {
			((IApplicationWindowActions) executable).init(applicationWindow);
		}

		super.createMenuItems(parentMenu, submemd, executable);
	}

	protected void createMenuItem(Menu parentMenu, MenuExtensionMetadata submemd, IAction executable) {
		if (executable instanceof IApplicationWindowAction) {
			((IApplicationWindowAction) executable).init(applicationWindow);
		}

		super.createMenuItem(parentMenu, submemd, executable);
	}

}