package org.simplextensions.ui.menu;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simplextensions.annotations.ExtensionPoint;
import org.simplextensions.annotations.ExtensionValidator;
import org.simplextensions.graph.Graph;
import org.simplextensions.registry.Extension;
import org.simplextensions.registry.IExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * 
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:57:58
 */
@ExtensionPoint(id = MenuExtensionPoint.ID, extensionClass = { IMenuExtension.class })
@ExtensionValidator(MenuExtensionValidator.class)
public class MenuExtensionPoint implements IExtensionPoint {

	private static final Logger log = LoggerFactory.getLogger(MenuExtensionPoint.class);

	public static final String ID = "MenuExtensionPoint";

	public static final String IMAGE = "image";
	public static final String PARENT = "parent";
	public static final String ORDER = "order";
	public static final String TYPE = "type";

	private Map<Extension, MenuExtensionMetadata> menuMap = new HashMap<Extension, MenuExtensionMetadata>();

	private Graph menuGraph = new Graph();

	public void initialize(org.simplextensions.registry.ExtensionPoint extensionPoint) {
		Collection<Extension> activeExtensions = extensionPoint.getActiveExtensions();
		for (Extension e : activeExtensions) {
			if (!menuMap.containsKey(e)) {
				MenuExtensionMetadata value = new MenuExtensionMetadata(menuGraph, e);
				menuMap.put(e, value);
				log.debug("new menu extension: " + value);
			}
		}
	}

	public MenuExtensionMetadata getMenu(String menuId) {
		for (MenuExtensionMetadata memd : menuMap.values()) {
			if (memd.getId().equals(menuId) && memd.getType() == MenuExtensionType.Menu) {
				return memd;
			}
		}
		return null;
	}

}
