package org.simplextensions.ui.preferences.xml;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class XmlTimestampAdapter extends XmlAdapter<String, Timestamp> {

	private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

	@Override
	public String marshal(Timestamp arg0) throws Exception {
		return df.format(arg0);
	}

	@Override
	public Timestamp unmarshal(String arg0) throws Exception {
		return new Timestamp(df.parse(arg0).getTime());
	}

}
