package org.simplextensions.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

import org.simplextensions.registry.Extension;
import org.simplextensions.registry.ExtensionPoint;
import org.simplextensions.registry.IExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.simplextensions.annotations.ExtensionPoint(id = ViewExtensionPoint.ID, extensionClass = { IView.class })
public class ViewExtensionPoint implements IExtensionPoint {

	private static final Logger log = LoggerFactory.getLogger(ViewExtensionPoint.class);

	public static final String ID = "ViewExtensionPoint";

	private Collection<Extension> extensions = new LinkedList<Extension>();

	public void initialize(ExtensionPoint extensionPoint) {
		log.info("initialize");
		for (Extension e : extensionPoint.getExtensions()) {
			if (e.isActive()) {
				if (!extensions.contains(e))
					extensions.add(e);
			} else
				extensions.remove(e);
		}
	}

	public Collection<IView<?>> getViews() {
		Collection<IView<?>> result = new ArrayList<IView<?>>(extensions.size());

		for (Extension e : extensions) {
			result.add((IView<?>) e.getExecutable());
		}

		return result;
	}

}
