/**
 * 
 */
package org.simplextensions.registry;

import java.util.Collection;

/**
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-08-04 10:27:43
 * 
 */
public interface IExtensionRegistry {

	/**
	 * 
	 * @param <T>
	 * @param clazz
	 * @return
	 */
	<T> T getExtensionPoint(Class<T> clazz);

	/**
	 * 
	 * @param <T>
	 * @param clazz
	 * @param id
	 * @return
	 */
	<T> T getExtensionPoint(Class<T> clazz, String id);

	/**
	 * 
	 * @param name
	 * @return
	 */
	Collection<Extension> getExtensionsMDByClass(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	Collection<ExtensionPoint> getExtensionPointsMDByClass(String name);

	/**
	 * 
	 * @param extensionPointId
	 * @return
	 */
	ExtensionPoint getExtensionPointMD(String extensionPointId);

	/**
	 * 
	 * @return
	 */
	Collection<ExtensionPoint> getExtensionPointsMD();

	/**
	 * 
	 * @param extensionPointId
	 * @return
	 */
	Collection<Extension> getExtensionsMD(String extensionPointId);

	/**
	 * 
	 * @param extension
	 */
	void addExtension(Extension extension, String pointId);

	/**
	 * 
	 * @param extensionPoint
	 */
	void addExtensionPoint(ExtensionPoint extensionPoint);

	/**
	 * 
	 * @param configurableElem
	 * @return
	 */
	Object createExecutable(ConfigurableElem configurableElem);

	void addBundle(SimpleXtensionsBundle bundle) throws InstantiationException, IllegalAccessException, ClassNotFoundException;

}
