package org.simplextensions.registry;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

import static org.junit.Assert.fail;
import static org.mockito.Matchers.same;
import static org.mockito.Mockito.*;

/**
 * Created by IntelliJ IDEA.
 * User: jan kowalski
 * Date: 05.02.11
 * Time: 22:44
 */

@RunWith(MockitoJUnitRunner.class)
public class ExtensionPointTest {

    @Mock
    IExtensionRegistry mock;


    @Spy
    FakeAnnotatedExtensionPoint annotatedPoint = new FakeAnnotatedExtensionPoint();

    @Spy
    FakeExtensionPoint point = new FakeExtensionPoint();

    @Test
    public void testStart() {

        ExtensionPoint extensionPoint = new ExtensionPoint(new SimpleXtensionsBundle(mock, "TestBundle"), annotatedPoint, "TestEP");

        extensionPoint.start();


        verify(annotatedPoint).start(same(extensionPoint));
        Assert.assertTrue(extensionPoint.isStarted());

    }

    @Test
    public void testStopWithoutStart() {

        ExtensionPoint extensionPoint = new ExtensionPoint(new SimpleXtensionsBundle(mock, "TestBundle"), annotatedPoint, "TestEP");

        try {
            extensionPoint.stop();
            fail();
        } catch (IllegalStateException e) {
            System.out.println(e.getMessage());
        }

        verifyNoMoreInteractions(annotatedPoint);


    }

    @Test
    public void testStop() {

        ExtensionPoint extensionPoint = new ExtensionPoint(new SimpleXtensionsBundle(mock, "TestBundle"), annotatedPoint, "TestEP");
        extensionPoint.start();
        extensionPoint.stop();

        verify(annotatedPoint).start(same(extensionPoint));
        verify(annotatedPoint).stop(same(extensionPoint));


        verifyNoMoreInteractions(annotatedPoint);


    }

    @Test
    public void testAdd() {

        ExtensionPoint extensionPoint = new ExtensionPoint(new SimpleXtensionsBundle(mock, "TestBundle"), annotatedPoint, "TestEP");
        extensionPoint.start();
        Extension mock1 = mock(Extension.class);
        extensionPoint.addExtension(mock1);

        verify(annotatedPoint).addExtension(same(mock1));

    }

    @Test
    public void testRemove() {

        ExtensionPoint extensionPoint = new ExtensionPoint(new SimpleXtensionsBundle(mock, "TestBundle"), annotatedPoint, "TestEP");
        extensionPoint.start();
        Extension mock1 = mock(Extension.class);
        extensionPoint.addExtension(mock1);

        extensionPoint.removeExtension(mock1);

        verify(annotatedPoint).addExtension(same(mock1));
        verify(annotatedPoint).removeExtension(same(mock1));

    }

}
