package org.simplextensions.ui;

import org.simplextensions.annotations.ioc.ServiceDependency;
import org.simplextensions.ioc.DependencyInjector;
import org.simplextensions.annotations.ioc.Registry;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.preferences.IPreferences;
import org.simplextensions.ui.preferences.IPreferencesService;

/**
 * Simple implementation of {@link IApplicationWindow}
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:56:53
 */
public class ApplicationWindow extends StatefulUIPartAdapter implements IApplicationWindow {

	@Registry
	private IExtensionRegistry extensionRegistry;

	@ServiceDependency
	private IPreferencesService preferencesService;

	public ApplicationWindow(IExtensionRegistry extensionRegistry) {
		DependencyInjector.resolveDependency(extensionRegistry, this);
	}

	public IExtensionRegistry getExtensionRegistry() {
		return this.extensionRegistry;
	}

	protected void openWindow(IPreferences preferences) {

	}

	public final void open() {
		IPreferences windowPreferences = preferencesService.get("ApplicationWindow", "SimpleXtensions-UI");
		openWindow(windowPreferences);
		preferencesService.save(windowPreferences);
	}

}
