package org.simplextensions.ui;

/**
 * interaface of SimpleXtensions UI service. this service reads
 * simplextension-ui.properties merges them and provides easy way to access
 * properties values.
 * 
 * It finds all simplextensions-ui.properties and merges properties according to
 * <b>priority</b> (int) property found in that file: properties from a higher
 * priority file overrides properties from a lower priority file. if priority
 * from one file equals priority from another properties values are randomly
 * chosen.
 * 
 * @author krzyzak
 * 
 */
public interface ISimpleXtensionsUIService {

	/**
	 * returns value of given property read from simplextensions-ui.properties
	 * file.
	 * 
	 * @param key
	 *            the property key
	 * @return value of given property or null when value is not defined or
	 *         equals "";
	 */
	String getProperty(String key);

}
