package org.simplextensions.ui.preferences;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 
 * Interface to a properties used for saving the important state of an
 * UserInterface.
 * 
 * This interface is not intended to be implemented or extended by clients.
 * 
 * 
 * @author krzyzak
 * 
 */
public interface IPreferences {

	/**
	 * returns id for this preferences
	 * 
	 * @return id for this preferences
	 */
	String getID();

	/**
	 * returns bundle id for this preferences
	 * 
	 * @return bundle id for this preferences
	 */
	String getBundleId();

	/**
	 * returns Integer value associated with given key
	 * 
	 * @param key
	 *            - the key
	 * @return Integer value associated with given key or null if no such
	 *         integer was found
	 */
	Integer getInteger(String key);

	/**
	 * returns BigDecimal value associated with given key
	 * 
	 * @param key
	 *            - the key
	 * @return BigDecimal value associated with given key or null if no such
	 *         BigDecimal was found
	 */
	BigDecimal getBigDecimal(String key);

	/**
	 * returns Boolean value associated with given key
	 * 
	 * @param key
	 *            - the key
	 * @return Boolean value associated with given key or null if no such
	 *         Boolean was found
	 */
	Boolean getBoolean(String key);

	/**
	 * returns Date value associated with given key
	 * 
	 * @param key
	 *            - the key
	 * @return Date value associated with given key or null if no such Date was
	 *         found
	 */
	Date getDate(String key);

	/**
	 * returns String value associated with given key
	 * 
	 * @param key
	 *            - the key
	 * @return String value associated with given key or null if no such String
	 *         was found
	 */
	String getString(String key);

	/**
	 * returns IPreferences value associated with given key
	 * 
	 * @param key
	 *            - the key
	 * @return IPreferences value associated with given key or null if no such
	 *         IPreferences was found
	 */
	IPreferences getPreferences(String key);

	/**
	 * creates new child preferences object with the given id. if there was
	 * already preferences child with the given id it is replaces with new one
	 * 
	 * @param key
	 *            - the key
	 * @return new preferences child
	 */
	IPreferences createChild(String key);

	/**
	 * sets the value of the given key with given bigdecimal value. if other
	 * value exists it is replaced
	 * 
	 * @param key
	 *            - the key
	 * @param value
	 *            - the value
	 */
	void setBigDecimal(String key, BigDecimal value);

	/**
	 * sets the value of the given key with given Boolean value. if other value
	 * exists it is replaced
	 * 
	 * @param key
	 *            - the key
	 * @param value
	 *            - the value
	 */
	void setBoolean(String key, Boolean value);

	/**
	 * sets the value of the given key with given Date value. if other value
	 * exists it is replaced
	 * 
	 * @param key
	 *            - the key
	 * @param value
	 *            - the value
	 */
	void setDate(String key, Date value);

	/**
	 * sets the value of the given key with given Integer value. if other value
	 * exists it is replaced
	 * 
	 * @param key
	 *            - the key
	 * @param value
	 *            - the value
	 */
	void setInteger(String key, Integer value);

	/**
	 * sets the value of the given key with given String value. if other value
	 * exists it is replaced
	 * 
	 * @param key
	 *            - the key
	 * @param value
	 *            - the value
	 */
	void setString(String key, String value);
	
	Set<String> getKeys();
	
	Object get(String key);

}
