package org.simplextensions.ui.preferences.xml;

import org.simplextensions.ui.preferences.IPreferences;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Preferences implements IPreferences {

	private final String id;
	private final String bundleId;

	private Map<String, Object> valuesMap = new HashMap<String, Object>();

	// this one will be used

	Preferences(String id, String bundleId) {
		this.id = id;
		this.bundleId = bundleId;
	}

	public IPreferences createChild(String key) {
		Object object = valuesMap.get(key);
		if (object == null || !(object instanceof IPreferences)) {
			object = new Preferences(key, bundleId);
			valuesMap.put(key, object);
		}
		return (IPreferences) object;
	}

	public BigDecimal getBigDecimal(String key) {
		return getObject(key, BigDecimal.class);
	}

	public Boolean getBoolean(String key) {
		return getObject(key, Boolean.class);
	}

	public String getBundleId() {
		return this.bundleId;
	}

	public Date getDate(String key) {
		return getObject(key, Date.class);
	}

	public String getID() {
		return this.id;
	}

	public Integer getInteger(String key) {
		return getObject(key, Integer.class);
	}

	public IPreferences getPreferences(String key) {
		return getObject(key, IPreferences.class);
	}

	public String getString(String key) {
		return getObject(key, String.class);
	}

	private <T> T getObject(String key, Class<T> class1) {
		Object object = this.valuesMap.get(key);
		if (object == null || !class1.isAssignableFrom(object.getClass()))
			return null;
		else
			return (T) object;
	}

	public void setBigDecimal(String key, BigDecimal value) {
		this.valuesMap.put(key, value);
	}

	public void setBoolean(String key, Boolean value) {
		this.valuesMap.put(key, value);
	}

	public void setDate(String key, Date value) {
		this.valuesMap.put(key, value);
	}

	public void setInteger(String key, Integer value) {
		this.valuesMap.put(key, value);
	}

	public void setString(String key, String value) {
		this.valuesMap.put(key, value);
	}
	
	public Object get(String key) {
		return this.valuesMap.get(key);
	}

	public Set<String> getKeys() {
		return this.valuesMap.keySet();
	}
	
	void set(String key, Object value){
		this.valuesMap.put(key, value);
	}
}
