package org.simplextensions.examples.settings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.simplextensions.ui.settings.ASWTSettingsEditor;
import org.simplextensions.ui.settings.annotations.SettingsEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SettingsEditor(id = "SampleSettingsEditor3")
public class CopyOfSampleSettingsEditor extends ASWTSettingsEditor {
	
	private static final Logger log = LoggerFactory.getLogger(CopyOfSampleSettingsEditor.class);

	public void createContents() {
		log.info("createView");

		Composite clientArea = getSettingsRegion().getClientArea();
		clientArea.setLayout(new GridLayout());
		Label label = new Label(clientArea, SWT.NORMAL);
		label.setText("Sample SimpleXtensions View");
		label.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));

		clientArea.redraw();
		clientArea.layout();
	}

	public String getName() {
		return "Sample Settings222";
	}

}
