package org.simplextensions.examples.settings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.simplextensions.ui.settings.ASWTSettingsEditor;
import org.simplextensions.ui.settings.annotations.SettingsEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@SettingsEditor(id = "SampleSettingsEditor2", parent = "SampleSettingsEditor")
public class SampleSettingsEditor2 extends ASWTSettingsEditor {

	private static final Logger log = LoggerFactory.getLogger(SampleSettingsEditor.class);

	public void createContents() {
		log.info("createView");

		Composite clientArea = getSettingsRegion().getClientArea();
		clientArea.setLayout(new GridLayout());
		Label label = new Label(clientArea, SWT.NORMAL);
		label.setText("Sample SimpleXtensions View 2");
		label.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));

		clientArea.redraw();
		clientArea.layout();
	}

	public String getName() {
		return "Sample Settings2";
	}

}
