package org.simplextensions.di;

import static junit.framework.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;
import org.simplextensions.Simplextensions;
import org.simplextensions.di.data.AnotherFooService;
import org.simplextensions.di.data.IAnotherFooService;
import org.simplextensions.di.data.IFooService;
import org.simplextensions.registry.IDependencyLocatorRegistry;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.IServiceRegistry;

public class InjectionTest {
	private IDependencyLocatorRegistry locatorsRegistry;
	private IServiceRegistry serviceRegistry;

	@Before
	public void setUp() {

		/*
		 * serviceRegistry = new ServiceRegistry(); serviceRegistry.start();
		 */
		IExtensionRegistry newRegistry = Simplextensions.createNewRegistry();
		locatorsRegistry = newRegistry.getExtensionPoint(IDependencyLocatorRegistry.class);
		serviceRegistry = newRegistry.getServiceRegistry();
		
		assertNotNull(serviceRegistry.getService(IFooService.class));
		
		// serviceRegistry.registerService(IFooService.class, new FooService());

	}

	@Test
	public void injectionOnDemand() {
		AnotherFooService fooObject = new AnotherFooService();

		DependencyInjector.resolveDependency(locatorsRegistry, fooObject);
		assertNotNull(fooObject.getService());
		assertNotNull(fooObject.getBaseService());
	}

	@Test
	public void dynamicInjection() {
		IAnotherFooService fooObject = serviceRegistry.getService(IAnotherFooService.class);

		assertNotNull(fooObject.getService());
		assertNotNull(fooObject.getBaseService());
	}
}
