package org.simplextensions.ioc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author Mirek Szajowski m.szajowski@gmail.com
 * 
 */
public abstract class ClassSearcherUtil {

	public static List<Field> getAllClassFields(Class<?> clazz) {
		List<Field> fields = new ArrayList<Field>();
		Class<?> currentClass = clazz;

		while (!currentClass.equals(Object.class)) {
			Field[] declaredFields = currentClass.getDeclaredFields();
			addFieldsToList(fields, declaredFields);
			currentClass = currentClass.getSuperclass();
		}
		return fields;
	}

	private static void addFieldsToList(List<Field> fieldsList, Field[] fieldsArray) {
		for (Field field : fieldsArray) {
			fieldsList.add(field);
		}
	}
}
