package org.simplextensions.registry;

public class ValidationStatus implements IValidationStatus {

	private final Severity severity;
	private final String message;

	public static IValidationStatus ok() {
		return new ValidationStatus(Severity.OK, null);
	}

	public static IValidationStatus failed() {
		return new ValidationStatus(Severity.ERROR, null);
	}

	public static IValidationStatus failed(String message) {
		return new ValidationStatus(Severity.ERROR, message);
	}

	private ValidationStatus(Severity severity, String message) {
		this.severity = severity;
		this.message = message;
	}

	public Severity getSeverity() {
		return severity;
	}

	public String getMessage() {
		return message;
	}

}
