package org.simplextensions.registry.phaselisteners;

import javassist.bytecode.annotation.Annotation;
import org.simplextensions.Utils;
import org.simplextensions.registry.*;
import org.simplextensions.registry.services.ServiceRegistry;
import org.simplextensions.scanner.ClassScannerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceScanPhaseListener implements ISimpleXtensionsClassScanner {

	private static final Logger log = LoggerFactory.getLogger(ServiceScanPhaseListener.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.simplextensions.core.scanner.IScanPhaseListener#scanClass(java
	 * .lang.Class, javassist.bytecode.annotation.Annotation)
	 */
	public void scanClass(SimpleXtensionsBundle bundle, String className, Annotation a) {
		log.trace("scanning service class: " + className);

		Class<?> serviceInterface = ClassScannerHelper.getClassValue(a, "value");
		String extensionId = serviceInterface.getSimpleName() + Utils.getSequenceValue(serviceInterface.getSimpleName());

		Extension extension = new Extension(bundle, className, extensionId);
		extension.setPropertyValue(ServiceRegistry.SERVICE_INTERFACE, new PropertyValue(serviceInterface));
		
		extension.setPropertyValue(ServiceRegistry.EXTENSION_TYPE, new PropertyValue(ServiceRegistry.EXTENSION_TYPE_SERVICE));

		bundle.getExtensionRegistry().addExtension(extension, ServiceRegistry.EP_ID);
	}

}