package org.simplextensions.registry.services;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * 
 * Annotation used at class indicating that class is implementation of some
 * service and offers functionality defined by <b>value</b></br></br>
 * 
 * Service(sometype.class)</br>
 * is replacement for: </br>
 * Extension</br>
 * Properties(@Property(name=IService.SERVICE_INTERFACE, classValue=sometype.class))
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 22-05-2010 09:37:19
 */
@Target(ElementType.TYPE)
public @interface Service {

	Class<?> value();

}
