package org.simplextensions.ui.menu;

import org.eclipse.swt.widgets.Menu;
import org.simplextensions.ui.view.IView;

public class ViewMenuManager extends MenuManager {

	private final IView<?> view;

	public ViewMenuManager(IView<?> view) {
		super(view.getExtensionRegistry());
		this.view = view;
	}

	protected void createMenuItems(Menu parentMenu, MenuExtensionMetadata submemd, IActions executable) {
		if (executable instanceof IViewActions) {
			((IViewActions) executable).init(this.view);
		}

		super.createMenuItems(parentMenu, submemd, executable);
	}

	protected void createMenuItem(Menu parentMenu, MenuExtensionMetadata submemd, IAction executable) {
		if (executable instanceof IViewAction) {
			((IViewAction) executable).init(this.view);
		}

		super.createMenuItem(parentMenu, submemd, executable);
	}
}
