package org.simplextensions.ui.menu;

import org.simplextensions.annotations.ioc.Registry;
import org.simplextensions.registry.IExtensionRegistry;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:57:27
 */
public abstract class MenuExtensionAdapter implements IMenuExtension {

	@Registry
	private IExtensionRegistry extensionRegistry;

	protected IExtensionRegistry getExtensionRegistry() {
		return extensionRegistry;
	}

	public String getLabel(MenuExtensionMetadata menuMetadata) {
		ResourceBundle bundle = ResourceBundle.getBundle(getClass().getPackage().getName() + ".messages");

		String key = menuMetadata.getId().replace("/", ".");
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return "!" + key + "!";
		}
	}

	public boolean isEnabled(MenuExtensionMetadata metadata) {
		return true;
	}

}
