package org.simplextensions.ui.settings;

import org.simplextensions.annotations.ioc.Registry;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.StatefulUIPartAdapter;

public abstract class ASettingsEditor<T extends ISettingsEditorRegion> extends StatefulUIPartAdapter implements ISettingsEditor<T> {

	private T region;

	@Registry
	private IExtensionRegistry extensionRegistry;

	public void init(T region) {
		this.region = region;
	}

	protected IExtensionRegistry getExtensionRegistry() {
		return extensionRegistry;
	}

	public T getSettingsRegion() {
		return region;
	}

}
