/*
Copyright (c) 2012, Felipe Michels Fontoura, Lucas Longen Gioppo,
Luís Guilherme Bergamini Mendes e Renato Girardi Gasoto.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Universidade Tecnológica Federal do Paraná nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package utfpr.sistemaestagios.dao.text;

import java.io.File;
import java.util.Collection;
import java.util.List;

import jtextdatastore.TextDataCondition;
import jtextdatastore.TextDataTable;
import utfpr.sistemaestagios.dao.DAOProfessor;
import utfpr.sistemaestagios.types.Professor;

/**
 * @author Felipe Michels Fontoura
 */
public class TextDAOProfessor implements DAOProfessor {
	private TextDataTable<Professor> table;

	public TextDAOProfessor(File folder) {
		table = new TextDataTable<Professor>(Professor.class, new File(folder, "professor.txt"));
	}

	public Professor insert(Professor professor) {
		if (table.insert(professor)) return professor;
		else return null;
	}

	public boolean delete(String codigoProfessor) {
		Professor professor = new Professor();
		professor.codigoProfessor = codigoProfessor;
		if (table.delete(professor)) return true;
		else return false;
	}

	public Professor find(String codigoProfessor) {
		Professor professor = new Professor();
		professor.codigoProfessor = codigoProfessor;
		TextDataCondition<Professor> condition = table.getMetadata().generatePrimaryKeyMatchesCondition(professor);
		List<Professor> professores = table.select(condition);
		if (professores == null) return null;
		if (professores.size() == 0) return null;
		return professores.get(0);
	}

	public Professor update(Professor professor) {
		if (table.update(professor)) return professor;
		else return null;
	}

	public Collection<Professor> select() {
		return table.select();
	}

	public Collection<Professor> select_byDepartamento(String departamento) {
		return table.select(new DepartamentoCondition(departamento));
	}

	private static class DepartamentoCondition implements TextDataCondition<Professor> {
		String departamento;
		public DepartamentoCondition(String departamento) {
			this.departamento = departamento;
		}
		public boolean accept(Professor item) {
			return item.departamento == departamento;
		}
	}
}
