/*
Copyright (c) 2012, Felipe Michels Fontoura, Lucas Longen Gioppo,
Luís Guilherme Bergamini Mendes e Renato Girardi Gasoto.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Universidade Tecnológica Federal do Paraná nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package utfpr.sistemaestagios.types;

import java.io.Serializable;
import java.util.Date;

import jtextdatastore.TextDataParams;

/**
 * @author Felipe Michels Fontoura
 * @author Luís Guilherme Bergamini Mendes
 * @author Renato Girardi Gasoto
 */
public class Estagio implements Serializable {
	private static final long serialVersionUID = 0xFED1D0L;

	@TextDataParams(name = "id_estagio", primaryKey = true)
	public long id; // get time millis na hora de criar....

	@TextDataParams(name = "comeco", priority = 0)
	public Date dataComeco;

	@TextDataParams(name = "final", priority = 1)
	public Date dataFinal;

	@TextDataParams(name = "codigo_professor", priority = 2)
	public String codigoProfessor;

	@TextDataParams(name = "id_empresa", priority = 3)
	public String idEmpresa;

	@TextDataParams(name = "matricula_aluno", priority = 4)
	public String codigoAluno;

	@TextDataParams(name = "descricao_do_plano", priority = 5)
	public String descricao;

	@TextDataParams(name = "estado_coordenador", priority = 6)
	public int estadoAprovacaoCoordenador;

	@TextDataParams(name = "estado_orientador", priority = 7)
	public int estadoAprovacaoOrientador;

	@TextDataParams(name = "visita_tecnica_data", priority = 8)
	public Date visita;

	@TextDataParams(name = "visita_tecnica_feita", priority = 9)
	public boolean visitaFeita;
	
	@TextDataParams(name = "obrigatorio", priority = 10)
	public boolean obrigatorio;
}
