package org.sapp;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * Initialize embedded OpenEjb instance
 * 
 * @author vitalii
 *
 */

public class OpenEjbFactory 
{
	private List<DataSource> dataSources = new LinkedList<DataSource>();
	
	/**
	 * Setup data source for using inside EJB
	 * Must be called before create()
	 * 
	 * @param dataSource
	 */
	
	public void addDataSource(DataSource dataSource)
	{
		dataSources.add(dataSource);
	}
	
	/**
	 * Create embedded OPenEjb instance.
	 * 
	 * @throws Exception
	 */
	
	public void create() throws Exception
	{
		setUpOpenEjb();
	}
	
	/**
	 * Lookup remote interface
	 * 
	 * @param beanName
	 * @return
	 * @throws Exception
	 */
	
	public Object lookupRemote(String beanName) throws Exception
	{
        Properties properties = new Properties();
        properties.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.apache.openejb.client.RemoteInitialContextFactory");
        properties.setProperty(Context.PROVIDER_URL, "ejbd://localhost:4201");
        InitialContext remoteContext = new InitialContext(properties);

        //SimpleRemote bean = (SimpleRemote) remoteContext.lookup("SimpleBeanRemote");
        //String retVal = bean.call("123");	
        
        return remoteContext.lookup(beanName);
	}
	
	/**
	 * Lookup local interface
	 * 
	 * @param beanName
	 * @return
	 * @throws Exception
	 */
	
	public Object lookupLocal(String beanName) throws Exception
	{
        Properties properties = new Properties();
        properties.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.apache.openejb.client.LocalInitialContextFactory");
        InitialContext localContext = new InitialContext(properties);

        //SimpleRemote bean = (SimpleRemote) localContext.lookup("SimpleBeanRemote");
        //String retVal = bean.call("123");
        
        return localContext.lookup(beanName);		
	}
	
	/**
	 * Setup and run embedded OpenEJB server
	 * 
	 * @throws Exception
	 */

    protected void setUpOpenEjb() throws Exception 
    {
        Properties properties = new Properties();
        properties.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.apache.openejb.client.LocalInitialContextFactory");
        properties.setProperty("openejb.embedded.remotable", "true");
        properties.setProperty("openejb.validation.output.level", "verbose");
        
        //p.put("openejb.home", "/opt/openejb.3.1");
		//p.put("openejb.configuration","/home/vitalii/ResearchWorkspace/TestJPA/conf/openejb.conf");
        
        //properties.put("jdbc/TestJPA", "new://Resource?type=DataSource");
        //properties.put("movieDatabase.JdbcDriver", "org.hsqldb.jdbcDriver");
        //properties.put("movieDatabase.JdbcUrl", "jdbc:hsqldb:mem:moviedb");        

        //properties.put("jdbc/TestJPA", "new://Resource?type=DataSource");
        //properties.put("jdbc/TestJPA.JdbcDriver", "com.mysql.jdbc.Driver");
        //properties.put("jdbc/TestJPA.JdbcUrl", "jdbc:mysql://localhost:3306/jpa_test");        
        //properties.put("jdbc/TestJPA.UserName", "root");
        //properties.put("jdbc/TestJPA.Password", "vitalii");  
        
        for(DataSource dataSource: dataSources)
        {
            properties.put(dataSource.getName(), "new://Resource?type=DataSource");
            properties.put(dataSource.getName()+".JdbcDriver", dataSource.getDriverClass());
            properties.put(dataSource.getName()+".JdbcUrl", dataSource.getJdbcUrl());        
            properties.put(dataSource.getName()+".UserName", dataSource.getUsername());
            properties.put(dataSource.getName()+".Password", dataSource.getPassword());
        }
        
        // Uncomment these properties to change the defaults
        //properties.setProperty("ejbd.port", "4202");
        //properties.setProperty("ejbd.bind", "localhost");
        //properties.setProperty("ejbd.threads", "200");
        //properties.setProperty("ejbd.disabled", "false");
        //properties.setProperty("ejbd.only_from", "127.0.0.1,192.168.1.1");

        new InitialContext(properties);
    }	
}
