package org.test.ejb;

import java.util.List;

import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;

import org.test.ejb.model.EmployeeController;
import org.test.jpa.model.Department;
import org.test.jpa.model.Employee;
import org.test.jpa.model.Phone;
import org.test.jpa.model.transfer.EmployeeTO;

@Remote
@Stateless(name = "EmployeeController")
public class EmployeeControllerBean implements EmployeeController 
{
    @PersistenceContext(unitName = "default" /*, type = PersistenceContextType.EXTENDED*/ )
    private EntityManager entityManager;	
	
	@Override
	public long createEmployee(String firstName, String lastName) 
	{
		// entityManager.getTransaction().begin();
		Department department = new Department();
		entityManager.persist(department);
		
		Employee employee = new Employee();
		employee.setFirstName(firstName);
		employee.setDepartment(department);
		entityManager.persist(employee);
		
		// entityManager.getTransaction().commit();
		
		return employee.getID();
	}    
    
	@Override
	public EmployeeTO[] getEmployee(String firstName, String lastName,
			int offset, int limit) 
	{
		Query q = entityManager.createNamedQuery("employeeByFullName");
		q.setParameter("firstName", firstName);
		q.setFirstResult(offset);
		q.setMaxResults(limit);
		List<Employee> results = q.getResultList();
		//for(Employee )
		//emplloyee = results.get(0);
		
		return null;
	}

	@Override
	public Phone[] getPhone(int employeeID) 
	{
		// TODO Auto-generated method stub
		return null;
	}
}
