package net.nm.skype;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;

import javax.swing.UIManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphicHandler implements ActionListener {

	// class-wide log
	private static Log log = LogFactory.getLog(GraphicHandler.class);

	MenuItem actionMenu = new MenuItem("Stop Recording");

	MenuItem viewMenu = new MenuItem("View last activities");

	MenuItem configMenu = new MenuItem("Configure...");

	MenuItem exitMenu = new MenuItem("Exit");

	TrayIcon ti;

	final Image imageStart = Toolkit.getDefaultToolkit().getImage(
			SystemTray.class.getResource("/start.gif"));

	final Image imageStop = Toolkit.getDefaultToolkit().getImage(
			SystemTray.class.getResource("/stop.gif"));

	boolean bugme = true;

	ActivityHandler controller;
	
	public void actionPerformed(ActionEvent e) {
		
		// action menu
		if (e.getSource().equals(actionMenu)) {
			if (controller.started) {
				actionMenu.setLabel("Start Recording");
				ti.setImage(imageStop);
				controller.started = false;
			} else {
				actionMenu.setLabel("Stop Recording");
				ti.setImage(imageStart);
				controller.started = true;
			}
		}

		// config menu
		if (e.getSource().equals(configMenu)) {

		}

		// view activity
		if (e.getSource().equals(viewMenu)) {
			if (Desktop.isDesktopSupported()) {
				Desktop desktop = Desktop.getDesktop();
				if (desktop.isSupported(Desktop.Action.BROWSE)) {
					try {
						URI uri = new URI("http://twitter.com/"+controller.twitter_accountID);
						desktop.browse(uri);
					} catch (Exception e1) {
						log.info("browsing error", e1);
					}
				}
			}
		}

		// exit menu
		if (e.getSource().equals(exitMenu)) {
			System.exit(0);
		}
	}

	public void init() throws Exception {
		// it's optional (just have the same look and feed
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

		if (SystemTray.isSupported()) {
			SystemTray tray = SystemTray.getSystemTray();
			PopupMenu menu = new PopupMenu();
			ti = new TrayIcon(imageStart, "Skype Activity Recorder", menu);
			menu.add(actionMenu);
			menu.add(viewMenu);
			// menu.add(new Separator());
			//menu.add(configMenu);
			menu.add(exitMenu);
			tray.add(ti);

			// couteur pour l'item "Hello World"
			actionMenu.addActionListener(this);
			configMenu.addActionListener(this);
			exitMenu.addActionListener(this);
			viewMenu.addActionListener(this);
			// display message
		}
	}

	public void notifyError(String message) {
		ti.displayMessage("Skype Activity Recorder", message,
				TrayIcon.MessageType.ERROR);
	}

	public void notifyInfo(String message) {
		if (bugme) {
			ti.displayMessage("Skype Activity Recorder", message,
					TrayIcon.MessageType.INFO);
		}
	}

	public void setBugme(boolean bugme) {
		this.bugme = bugme;
	}

	public void setController(ActivityHandler controller) {
		this.controller = controller;
	}
}
