package org.sp.model;

import javax.xml.datatype.XMLGregorianCalendar;

/**
 * Information about the GPX file, author, and copyright restrictions goes
 * in the metadata section. Providing rich, meaningful information about your
 * GPX files allows others to search for and use your GPS data.
 * 
 * @author Peter Lin
 *
 */
public class MetaData {
	private String name;
	private String desc;
	private Person author;
	private Copyright copyright;
	private XMLGregorianCalendar time;
	private String keywords;
	private Bounds bounds;
	private Extension extensions;

    public MetaData() {
    	super();
    }

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public Person getAuthor() {
		return author;
	}

	public void setAuthor(Person author) {
		this.author = author;
	}

	public Copyright getCopyright() {
		return copyright;
	}

	public void setCopyright(Copyright copyright) {
		this.copyright = copyright;
	}

	public XMLGregorianCalendar getTime() {
		return time;
	}

	public void setTime(XMLGregorianCalendar time) {
		this.time = time;
	}

	public String getKeywords() {
		return keywords;
	}

	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	public Bounds getBounds() {
		return bounds;
	}

	public void setBounds(Bounds bounds) {
		this.bounds = bounds;
	}

	public Extension getExtensions() {
		return extensions;
	}

	public void setExtensions(Extension extensions) {
		this.extensions = extensions;
	}
    
}
