package org.sp.model;

import java.math.BigDecimal;

/**
 * SensorExtension encapsulates heart rate monitor (HRM), speed, cadence and power meter properties.
 * It assumes the TrackPoint is recording those values when lat/long are recorded.
 * 
 * @author Peter Lin
 *
 */
public class SensorExtension extends Extension {

	public static final String CADENCE = "cadence";
	public static final String HEART_RATE_MONITOR = "hrmonitor";
	public static final String POWER_METER = "pmeter";
	public static final String SPEED = "speed";
	public static final String SPEEDTYPE = "speedType";
	public static final String MPH = "mph";
	public static final String KPH = "kp/h";
	
	public SensorExtension() {
		this.nameValueMap.put(SPEEDTYPE, MPH);
	}

	public void setCadence(Integer cadence) {
		this.nameValueMap.put(CADENCE, cadence);
	}
	
	public Integer getCadence() {
		return (Integer)this.nameValueMap.get(CADENCE);
	}
	
	public void setHRMonitor(Integer hrate) {
		this.nameValueMap.put(HEART_RATE_MONITOR, hrate);
	}
	
	public Integer getHRMonitor() {
		return (Integer)this.nameValueMap.get(HEART_RATE_MONITOR);
	}
	
	public void setPowerMeter(Integer power) {
		this.nameValueMap.put(POWER_METER, power);
	}
	
	public Integer getPowerMeter() {
		return (Integer)this.nameValueMap.get(POWER_METER);
	}
	
	public void setSpeed(BigDecimal speed) {
		this.nameValueMap.put(SPEED, speed);
	}
	
	public BigDecimal getSpeed() {
		return (BigDecimal)this.nameValueMap.get(SPEED);
	}
	
	public void setSpeedType(String type) {
		this.nameValueMap.put(SPEEDTYPE, type);
	}
	
	public String getSpeedType() {
		return (String)this.nameValueMap.get(SPEEDTYPE);
	}
}
