package org.sp.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * Track is an ordered list of points describing a path
 * 
 * @author Peter Lin
 *
 */
public class Track {
	private String name;
	private String description;
	private String source;
	private BigInteger number;
	private String type;
	private Extension extensions;
	private List<TrackSegment> trackSegments;

    public Track() {
    	super();
    }

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public BigInteger getNumber() {
		return number;
	}

	public void setNumber(BigInteger number) {
		this.number = number;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Extension getExtensions() {
		return extensions;
	}

	public void setExtensions(Extension extensions) {
		this.extensions = extensions;
	}

	public List<TrackSegment> getTrackSegments() {
		if (trackSegments == null) {
			trackSegments = new ArrayList<TrackSegment>();
		}
		return trackSegments;
	}

	public void setTrackSegments(List<TrackSegment> trackSegments) {
		this.trackSegments = trackSegments;
	}
    
}
