package org.sp.utils;

import java.util.ArrayList;
import java.util.List;

import org.sp.model.*;

import com.garmin.xmlschemas.trackpointextension.v1.TrackPointExtensionT;
import com.topografix.gpx._1._1.GpxType;
import com.topografix.gpx._1._1.MetadataType;
import com.topografix.gpx._1._1.TrkType;
import com.topografix.gpx._1._1.TrksegType;
import com.topografix.gpx._1._1.WptType;

public class GPXTransform {

	public GPXTransform() {
	}

	public GPX normalize(GpxType gpx11) {
		GPX normalized = new GPX();
		normalized.setCreator(gpx11.getCreator());
		normalized.setVersion(gpx11.getVersion());
		if (gpx11.getMetadata() != null) {
			this.translateMetadata(normalized, gpx11);
		}
		if (gpx11.getTrk() != null) {
			this.translateTrack(normalized, gpx11);
		}
		if (gpx11.getExtensions() != null) {
			
		}
		return normalized;
	}
	
	public void translateMetadata(GPX modelGPX, GpxType gpxT) {
		MetadataType mdt = gpxT.getMetadata();
		MetaData md = new MetaData();
		// Create the Person/Business that authored the file
		if (mdt.getAuthor() != null) {
			Person author = new Person();
			author.setName(mdt.getAuthor().getName());
			Email email = new Email();
			email.setDomain(mdt.getAuthor().getEmail().getDomain());
			email.setId(mdt.getAuthor().getEmail().getId());
			author.setEmail(email);
			md.setAuthor(author);
		}
		
		// create the Copyright
		if (mdt.getCopyright() != null) {
			Copyright cp = new Copyright();
			cp.setAuthor(mdt.getCopyright().getAuthor());
			cp.setLicense(mdt.getCopyright().getLicense());
			cp.setYear(mdt.getCopyright().getYear());
			md.setCopyright(cp);
		}
		
		// set bounds
		if (mdt.getBounds() != null) {
			Bounds bounds = new Bounds();
			bounds.setMaxLatitude(mdt.getBounds().getMaxlat());
			bounds.setMaxLongitude(mdt.getBounds().getMaxlon());
			bounds.setMinLatitude(mdt.getBounds().getMinlat());
			bounds.setMinLongitude(mdt.getBounds().getMinlon());
			md.setBounds(bounds);
		}
		
		md.setName(mdt.getName());
		md.setDesc(mdt.getDesc());
		md.setKeywords(mdt.getKeywords());
		md.setTime(mdt.getTime());
	}
	
	public void translateTrack(GPX modelGPX, GpxType gpxT) {
		List<TrkType> trkTList = gpxT.getTrk();
		List<Track> trackList = new ArrayList<Track>(trkTList.size());
		modelGPX.setTrackList(trackList);
		for (TrkType tk: trkTList) {
			Track track = new Track();
			trackList.add(track);
			track.setDescription(tk.getDesc());
			track.setName(tk.getName());
			track.setNumber(tk.getNumber());
			track.setSource(tk.getSrc());
			track.setType(tk.getType());
			this.translateTrackSegment(track, tk);
		}
	}
	
	public void translateTrackSegment(Track modelTrack, TrkType trkT) {
		List<TrksegType> tsgList = trkT.getTrkseg();
		List<TrackSegment> segmentList = new ArrayList<TrackSegment>(tsgList.size());
		modelTrack.setTrackSegments(segmentList);
		for (TrksegType tst: tsgList) {
			TrackSegment segment = new TrackSegment();
			segmentList.add(segment);
			this.translateWaypoint(segment, tst);
		}
	}
	
	public void translateWaypoint(TrackSegment modelSegment, TrksegType trkseg) {
		List<WptType> wptList = trkseg.getTrkpt();
		List<TrackPoint> trackPointList = new ArrayList<TrackPoint>();
		modelSegment.setTrackPoints(trackPointList);
		for (WptType wpt: wptList) {
			TrackPoint trackPt = new TrackPoint();
			trackPointList.add(trackPt);
			trackPt.setAgeOfdGPSData(wpt.getAgeofdgpsdata());
			trackPt.setdGPSId(wpt.getDgpsid());
			trackPt.setElevation(wpt.getEle());
			trackPt.setFix(wpt.getFix());
			trackPt.setGeoidHeight(wpt.getGeoidheight());
			trackPt.setHorizontalDilutionOfPrecision(wpt.getHdop());
			trackPt.setLatitude(wpt.getLat());
			trackPt.setLongitude(wpt.getLon());
			trackPt.setMagneticVariation(wpt.getMagvar());
			trackPt.setNumberOfSatellites(wpt.getSat());
			trackPt.setPositionDilutionOfPrecision(wpt.getPdop());
			trackPt.setSource(wpt.getSrc());
			trackPt.setTime(wpt.getTime());
			trackPt.setVerticalDilutionOfPrecision(wpt.getVdop());
			TrackPointExtensionT tpet = wpt.getExtensions().getGarminExtension();
			if (tpet != null) {
				SensorExtension snsExt = new SensorExtension();
				trackPt.setExtensions(snsExt);
				snsExt.setCadence((int)tpet.getCad());
				snsExt.setHRMonitor((int)tpet.getHr());
			}
		}
	}
	
}
