package com.topografix.gpx._1._1;

import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import com.garmin.xmlschemas.trackpointextension.v1.TrackPointExtensionT;

import junit.framework.TestCase;

public class ReadTest extends TestCase {

	public ReadTest() {
	}

	public ReadTest(String name) {
		super(name);
	}

	@SuppressWarnings("rawtypes")
	public void testReadCyclemeterFile() {
		String file = "./samples/Cyclemeter-Cycle-rose32-4-28.gpx";
		JAXBElement gpxobj = null;
		try {
			JAXBContext context = JAXBContext.newInstance(GpxType.class);
			gpxobj = (JAXBElement)context.createUnmarshaller().unmarshal(new java.io.File(file));
			assertTrue(gpxobj != null);
			if (gpxobj != null && gpxobj.getValue() instanceof GpxType) {
				GpxType gpxType = (GpxType)gpxobj.getValue();
				TrackPointExtensionT tpx = gpxType.getTrk().get(0).getTrkseg().get(0).getTrkpt().get(0).getExtensions().getGarminExtension();
				System.out.println(gpxType.getCreator());
				System.out.println(tpx.getCad());
			}
		} catch (JAXBException e) {
			e.printStackTrace();
			fail();
		}
	}
	
	public void testReadStravaFile() {
		String file = "./samples/44.97 miles - great rose32 ride.gpx";
		JAXBElement gpxobj = null;
		try {
			JAXBContext context = JAXBContext.newInstance(GpxType.class);
			gpxobj = (JAXBElement)context.createUnmarshaller().unmarshal(new java.io.File(file));
			assertTrue(gpxobj != null);
			if (gpxobj != null && gpxobj.getValue() instanceof GpxType) {
				GpxType gpxType = (GpxType)gpxobj.getValue();
				TrackPointExtensionT tpx = gpxType.getTrk().get(0).getTrkseg().get(0).getTrkpt().get(0).getExtensions().getGarminExtension();
				System.out.println(gpxType.getCreator());
				System.out.println(tpx.getCad());
			}
		} catch (JAXBException e) {
			e.printStackTrace();
			fail();
		}
	}
}
