package mainsearch.data;

import java.util.ArrayList;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class MainSearchTests {

	private int startSize;

	public void runTestCases(ArrayList<String> codeInjection,
			int codeInjectionSize) {
		ArrayList<String> webElements = new ArrayList<String>();
		webElements.add("email");
		webElements.add("password");
		searchCodeInjectionTests(codeInjection, codeInjectionSize, webElements);
		searchOptionsTests();
		
	}

	private void searchOptionsTests() {
		WebDriver driver = new FirefoxDriver();
		driver.get("https://snapsation.com");
		WebElement query = driver.findElement(By.xpath("(//input[@id='search-basic'])[2]"));
		query.sendKeys("Adrian");
		WebElement select = driver.findElement(By.xpath("(//select[@name='type'])[2]"));
		Select mySelect = new Select(select);
		mySelect.selectByValue("all");
		mySelect.selectByValue("peopleAndPets");
		mySelect.selectByValue("things");
		mySelect.selectByValue("events");
		mySelect.selectByValue("buldings");
		mySelect.selectByValue("weddingAndEngagement");
		mySelect.selectByValue("training");
		query.submit();
		try {
			Thread.sleep(1800);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void searchCodeInjectionTests(ArrayList<String> codeInjection,
			int codeInjectionSize, ArrayList<String> webElements) {
		for(startSize = 1; startSize < codeInjectionSize; startSize++){
			WebDriver driver = new FirefoxDriver();
			driver.get("https://snapsation.com");
			WebElement query = driver.findElement(By.xpath("(//input[@id='search-basic'])[2]"));
			query.sendKeys(codeInjection.get(startSize));
			query.submit();
			try {
				Thread.sleep(1800);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}

}
