package profilesettings.core;

import java.util.ArrayList;


import profilesettings.data.AboutMeTests;
import profilesettings.data.CoverImageTests;
import profilesettings.data.EmailAddressTests;
import profilesettings.data.LocatedTests;
import profilesettings.data.PasswordTests;
import profilesettings.data.PaymentsTests;
import profilesettings.data.PersonalUrlTests;
import profilesettings.data.ProfileImageTests;
import profilesettings.data.SnapographerTests;
import profilesettings.data.SocialTests;
import profilesettings.data.YourNameTests;
import profilesettings.ui.ProfileSettingsTestsDecision;
import testrunner.core.TestRunner;


public class ProfileSettingsTestRunner {

	public void run(ArrayList<String> codeInjection, int codeInjectionSize) {
		
		String decision = getDecisionFromUser();
		switch(decision){
		case "profileImage":
			/*ProfileImageTests profileImageTests = new ProfileImageTests();
			profileImageTests.run(codeInjection, codeInjectionSize);*/
			break;
		case "coverImage":
			/*CoverImageTests coverImageTests = new CoverImageTests();
			coverImageTests.run(codeInjection, codeInjectionSize); */
			break;
		case "emailAddress":
			EmailAddressTests emailAddressTests = new EmailAddressTests();
			emailAddressTests.run(codeInjection, codeInjectionSize);
			break;
		case "yourName":
			YourNameTests yourNameTests = new YourNameTests();
			yourNameTests.run(codeInjection, codeInjectionSize);
			break;
		case "password":
			PasswordTests passwordTests = new PasswordTests();
			passwordTests.run(codeInjection, codeInjectionSize);
			break;
		case "snapographer":
			SnapographerTests snapoGrapherTests = new SnapographerTests();
			snapoGrapherTests.run(codeInjection, codeInjectionSize);
			break;
		case "personalUrl":
			PersonalUrlTests personalUrlTests = new PersonalUrlTests();
			personalUrlTests.run(codeInjection, codeInjectionSize);
			break;
		case "aboutMe":
			AboutMeTests aboutMeTests = new AboutMeTests();
			aboutMeTests.run(codeInjection, codeInjectionSize);
			break;
		case "located":
			LocatedTests locatedTests = new LocatedTests();
			locatedTests.run(codeInjection, codeInjectionSize);
			break;
		case "payments":
			PaymentsTests paymentsTests = new PaymentsTests();
			paymentsTests.run(codeInjection, codeInjectionSize);
			break;
		case "social":
			SocialTests socialTests = new SocialTests();
			socialTests.run(codeInjection, codeInjectionSize);
			break;
		default:
			TestRunner testRunner = new TestRunner();
			try {
				testRunner.run();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}

	private String getDecisionFromUser() {
		ProfileSettingsTestsDecision profileSettingsTestsDecision = new ProfileSettingsTestsDecision();
		String decision = profileSettingsTestsDecision.getDecision();
		return decision;
	}

}
