package starter.logic;

import java.util.ArrayList;

import mainsearch.data.MainSearchTests;

import starter.data.CreateOfferTestCases;
import starter.data.CreditCardTestCases;
import starter.data.ForgotenTestCases;
import starter.data.LoginTestCases;
import starter.data.ProfileReviewTestCases;
import starter.data.ProfileSettingsTestCases;
import starter.data.ProfileTestCases;
import starter.data.RegisterTestCases;
import starter.data.LogoutTestCases;
import starter.data.LoginFBTestCases;
import starter.data.LoginGooglePlusTestCases;
import starter.data.ReviewTestCases;
import starter.data.MessagesTestCases;
import testrunner.core.TestRunner;

import codeinjection.data.CodeInjection;

public class StartModule implements Startable_Interface {

	@Override
	public void start(String testerDecision) throws InterruptedException {
		
		ArrayList<String> codeInjection = new ArrayList<String>();
		
		CodeInjection exampleInjections = new CodeInjection();
		codeInjection = exampleInjections.codeInjection();
		
		moduleAction(codeInjection, testerDecision);
		
	}

	private void moduleAction(ArrayList<String> codeInjection,
			String testerDecision) throws InterruptedException {
		int codeInjectionSize = codeInjection.size();
		switch(testerDecision){
		case "mainSearch":
			MainSearchTests mainSearchTests = new MainSearchTests();
			mainSearchTests.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "login":
			LoginTestCases loginTestCases = new LoginTestCases();
			loginTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "register":
			RegisterTestCases registerTestCases = new RegisterTestCases();
			registerTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "forgoten":
			ForgotenTestCases forgotenTestCases = new ForgotenTestCases();
			forgotenTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "logout":
			LogoutTestCases logoutTestCases = new LogoutTestCases();
			logoutTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "loginFb":
			LoginFBTestCases loginFbTestCases = new LoginFBTestCases();
			loginFbTestCases.runTestCases(codeInjection);
			break;
		case "loginG+":
			LoginGooglePlusTestCases loginGooglePlusTestCases = new LoginGooglePlusTestCases();
			loginGooglePlusTestCases.runTestCases(codeInjection);
			break;
		case "createOffer":
			CreateOfferTestCases createOfferTestCases = new CreateOfferTestCases();
			createOfferTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "profile":
			ProfileTestCases profileTestCases = new ProfileTestCases();
			profileTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "reviews":
			ReviewTestCases reviewTestCases = new ReviewTestCases();
			reviewTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "profileReviews":
			ProfileReviewTestCases profileReviewsTestCases = new ProfileReviewTestCases();
			profileReviewsTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "profileSettings":
			ProfileSettingsTestCases profileSettingsTestCases = new ProfileSettingsTestCases();
			profileSettingsTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "messages":
			MessagesTestCases messagesTestCases = new MessagesTestCases();
			messagesTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		case "creditCard":
			CreditCardTestCases creditCardTestCases = new CreditCardTestCases();
			creditCardTestCases.runTestCases(codeInjection, codeInjectionSize);
			break;
		default:
			TestRunner testRunner = new TestRunner();
			testRunner.run();
		}
		
	}

}
