package tests.testrunner;

import static org.junit.Assert.*;

import org.junit.Test;

import testrunner.logic.DecisionParser;

public class DecisionParserLogicalTests {

	@Test
	public void verifyYactualYexpectedTrue() throws InterruptedException {
		
		DecisionParser decisionParser = new DecisionParser();
		boolean actual = decisionParser.verify("y");
		boolean expected = true;
		assertEquals(expected, actual);
		
	}
	
	@Test
	public void verifyYactualYexpectedFalse() throws InterruptedException {
		
		DecisionParser decisionParser = new DecisionParser();
		boolean actual = decisionParser.verify("y");
		boolean expected = false;
		assertEquals(expected, actual);
		
	}
	
	@Test
	public void verifyYactualNexpectedTrue() throws InterruptedException{
		
		DecisionParser decisionParser = new DecisionParser();
		boolean actual = decisionParser.verify("n");
		boolean expected = true;
		assertEquals(expected, actual);
		
	}
	
	@Test
	public void verifyNactualNexpectedFalse() throws InterruptedException{
		
		DecisionParser decisionParser = new DecisionParser();
		boolean actual = decisionParser.verify("n");
		boolean expected = false;
		assertEquals(expected, actual);
		
	}
	
	/**
	 * If you want test else values, uncoment this items
	 *
	@Test
	public void verifyAnythingElseexpectedTrue(){
		
		DecisionParser decisionParser = new DecisionParser();
		boolean actual = decisionParser.verify("");
		boolean expected = true;
		assertEquals(expected, actual);
		
	}
	
	public void verifyAnythingElseexpectedFalse(){
		
		DecisionParser decisionParser = new DecisionParser();
		boolean actual = decisionParser.verify("");
		boolean expected = false;
		assertEquals(expected, actual);
		
	}
	*/

}
