package Controller;


import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;

import Domain.Airline;
import Domain.Airplane;
import Domain.Airport;
import Domain.Booking;
import Domain.FlightInstance;
import Domain.Passenger;
import Domain.PassengerSeat;
import Domain.PaymentInfo;
import Domain.SearchTerms;
import Domain.Trip;
import Domain.TripList;


public class Controller {

		public Controller(){
		}
	       
        //Pre: true
        //Post: has returned search results if valid search
		//else exception is thrown
        public TripList searchTrips(SearchTerms st) throws Exception {
        	
        	if( !isValidSearchTerms(st) )
        		throw new Exception("Error in search terms");
        	Date adate = st.getDepartureDateTime();
        	       	
        	
            ArrayList<Trip> searchResults = new ArrayList<Trip>();
            Connection con1 = null;
            Queue<ArrayList<FlightInstance>> queue = new LinkedList<ArrayList<FlightInstance>>();
            ArrayList<Connection> connections = new ArrayList<Connection>();
            ArrayList<Airline> airlines = new ArrayList<Airline>();
            
            try {
      	      Class.forName("com.mysql.jdbc.Driver").newInstance();
      	      con1 = DriverManager.getConnection("jdbc:mysql://localhost:3306/test",
      	        "root", "c4io@klmys");
      	      Airline airline1 = new Airline("AIR1","Airline1",(float) 0.10);
      	      
      	      connections.add(con1);
      	      airlines.add(airline1);
      	      
      	      
      	      ArrayList<FlightInstance> flights = new ArrayList<FlightInstance>();
      	      
      	      for(int i=0;i<connections.size();i++){
      	    	flights = getFlights(connections.get(i),st.getDepartureCity(),adate,airlines.get(i),st.getNumberOfPassenger());
      	    	for(int j=0;j<flights.size();j++){
      	    		ArrayList<FlightInstance> temp = new ArrayList<FlightInstance>();
      	    		temp.add(flights.get(j));
      	    		queue.offer(temp);
      	    	}
      	      }
      	      //System.out.println(queue.size());
      	      
      	      while(queue.isEmpty()!=true){
      	    	  ArrayList<FlightInstance> tmp = queue.poll();
      	    	  //System.out.println(queue.size());
      	    	  //ShowResults(tmp);
      	    	  String newcity = tmp.get(tmp.size()-1).getArrivalAirport().getCity();
      	    	  int comp = newcity.compareTo(st.getArrivalCity());
      	    	  if(comp==0){
      	    		  Trip trp = new Trip(tmp);
      	    		  searchResults.add(trp);
      	    		  //System.out.println("+1");
      	    	  }else{  	  
      	    		  if(tmp.size()<4){
		      	    	  Date newdate = new Date(tmp.get(tmp.size()-1).getArrivalTime().getTime()+
		      	    	  				60*1000*tmp.get(tmp.size()-1).getArrivalAirport().getConnectionTime());
		      	    	  for(int i=0;i<connections.size();i++){
		          	    	flights = getFlights(connections.get(i),newcity,newdate,airlines.get(i),st.getNumberOfPassenger());
		          	    	for(int j=0;j<flights.size();j++){
		          	    		boolean loop = false;
		          	    		for(int k=0;k<tmp.size();k++){
		          	    			int res = tmp.get(k).getDepartureAirport().getCity().compareTo(
		          	    					flights.get(j).getArrivalAirport().getName());
		          	    			if(res==0){
		          	    				loop = true;
		          	    			}
		          	    		}
		          	    		if(!loop){
		          	    			ArrayList<FlightInstance> temp = new ArrayList<FlightInstance>();
		          	    			temp.addAll(tmp);
		          	    			temp.add(flights.get(j));
		          	    			queue.offer(temp);
		          	    		}
		          	    	}
		      	    	  }
		        	  }
      	    	  }
      	      }
      	    } catch(SQLException e) {
      	      throw new Exception("Database error");
      	    } finally {
      	    	for(int i=0;i<connections.size();i++)
      	    		if(connections.get(i) != null)
      	    			connections.get(i).close();
      	    }
            
      	    TripList res = new TripList(searchResults);
            return res;
        }
        
        //Pre: true
        //Post: has returned all flights from DepartureCity
        //that departure between aDate and aDate+24h and have at least NumOfPass empty seats
        private ArrayList<FlightInstance> getFlights(Connection con,String departurecity, Date adate,Airline wairline, int numofpass) throws SQLException{
        	Date bdate = new Date();
        	int wHour = 24;
        	bdate.setTime(adate.getTime() + wHour*60*60*1000);
        	
        	PreparedStatement ps = con.prepareStatement(
        	"SELECT flightinstance.date AS date, flight.departuretime AS departuretime,"+
        		"flight.arrivaltime AS arrivaltime, flightinstance.serialnumber AS serialnumber,"+
        		"flight.flightnumber AS flightnumber, flight.fare AS fare,"+
        		"airport1.code AS dcode, airport1.name AS dname, airport1.city AS dcity,"+
        		"airport1.country AS dcountry, airport1.connectiontime AS dconnectiontime,"+
        		"airport2.code AS acode, airport2.name AS aname, airport2.city AS acity,"+
        		"airport2.country AS acountry, airport2.connectiontime AS aconnectiontime,"+
        		"airplane.type AS airplanetype, airplane.name AS airplanename "+
        	"FROM  flight INNER JOIN airport AS airport1 ON flight.fk_departureairport=airport1.ID "+
        		"INNER JOIN airport AS airport2 ON flight.fk_arrivalairport=airport2.ID "+
        		"INNER JOIN flightinstance ON flight.flightnumber=flightinstance.fk_flight "+
        		"INNER JOIN airplane ON flightinstance.fk_airplane=airplane.ID "+
        		"INNER JOIN seatinstance ON flightinstance.serialnumber=seatinstance.fk_flightinstancesn "+
        	"WHERE airport1.city=? "+
        		"AND ((flightinstance.date=? AND flight.departuretime>=?) "+
        		"OR  (flightinstance.date=? AND flight.departuretime<=?)) "+
        		"AND seatinstance.empty=1 "+
        	"GROUP BY serialnumber "+
        	"HAVING COUNT(serialnumber)>=?; " );
        	
        	ps.setString(1, departurecity);
        	ps.setString(2, new SimpleDateFormat("yyyy-MM-dd").format(adate));
        	ps.setString(3, new SimpleDateFormat("HH:mm:ss").format(adate));
        	ps.setString(4, new SimpleDateFormat("yyyy-MM-dd").format(bdate));
        	ps.setString(5, new SimpleDateFormat("HH:mm:ss").format(bdate));
        	ps.setInt(6, numofpass);
        	       	
        	ArrayList<FlightInstance> list = new ArrayList<FlightInstance>();
        	
        	ResultSet rs = ps.executeQuery();
        	while (rs.next()) {
        		
                String dcode = rs.getString("dcode");
                String dname = rs.getString("dname");
                String dcity = rs.getString("dcity");
                String dcountry = rs.getString("dcountry");
                int dconntime = rs.getInt("dconnectiontime");
                Airport departureairport = new Airport(dcode,dname,dcity,dcountry,dconntime);
                
                String acode = rs.getString("acode");
                String aname = rs.getString("aname");
                String acity = rs.getString("acity");
                String acountry = rs.getString("acountry");
                int aconntime = rs.getInt("aconnectiontime");
                Airport arrivalairport = new Airport(acode,aname,acity,acountry,aconntime);
                
                String airplanetype = rs.getString("airplanetype");
                String airplanename = rs.getString("airplanename");
                Airplane wairplane = new Airplane(airplanetype,airplanename);
                
                int serialnumber = rs.getInt("serialnumber");
                int flightnumber = rs.getInt("flightnumber");
                float fare = rs.getFloat("fare");
                
                Date wdate = rs.getDate("date");
                Time dtime = rs.getTime("departuretime");
                Time atime = rs.getTime("arrivaltime");
                
                Date departuredate = new Date(wdate.getTime()+dtime.getTime()+60*60*1000);
                Date arrivaldate = new Date(wdate.getTime()+atime.getTime()+60*60*1000);
                     
                FlightInstance fi = new FlightInstance(serialnumber, flightnumber,
                		fare, departureairport, arrivalairport, departuredate, arrivaldate,
                		wairplane, wairline);
                list.add(fi);
        	}
          	return list;
        }
        
        //Pre: true
        //Post: has returned true if search terms are valid
        private boolean isValidSearchTerms(SearchTerms st) {
                
                //Checks if arrival and departure cities are different
                if( st.getArrivalCity() == st.getDepartureCity() )
                	return false;
                
                //Checks if departure date is later than today
                Date nowDate = new Date();
                if( st.getDepartureDateTime().before(nowDate))
                	return false;
                
                return true;
        }
        
        //Pre: selected trip, passengers with their seat preferences
        //Post: has returned booking with passengers and their seats according with preferences
        public Booking findSeats(Booking book) throws Exception{
        	
        	int num = book.getPassengers().size();
        	String[] preferences = new String[num];
        	ArrayList<ArrayList<PassengerSeat>> tempSeat = new ArrayList<ArrayList<PassengerSeat>>();
        	for(int i=0;i<num;i++){
        		preferences[i]=book.getPassengers().get(i).getPreferredSeat();
        		tempSeat.add(new ArrayList<PassengerSeat>());
        	}
        	
        	
        	ArrayList<Connection> connections = new ArrayList<Connection>();
            ArrayList<Airline> airlines = new ArrayList<Airline>();
            Connection con1 = null;
            
            try {
      	      Class.forName("com.mysql.jdbc.Driver").newInstance();
      	      con1 = DriverManager.getConnection("jdbc:mysql://localhost:3306/test",
      	        "root", "c4io@klmys");
      	      Airline airline1 = new Airline("AIR1","Airline1",(float) 0.10);
      	      
      	      connections.add(con1);
      	      airlines.add(airline1);
				
      	      ArrayList<PassengerSeat> seats = new ArrayList<PassengerSeat>();
      	      for(int i=0;i<book.getTrip().size();i++){
      	    	
      	    	for(int j=0;j<connections.size();j++){
      	    		int res = airlines.get(j).getCode().compareTo(book.getTrip().getFlightInstance(i).getAirline().getCode());
      	    		if(res==0){
      	    			seats = getSeats(connections.get(j),book.getTrip().getFlightInstance(i).getSerialNumber());
      	    			if(seats.size()<book.getPassengers().size()){
      	    				throw new Exception("There are no available seats");
      	    			}
      	    			System.out.println(seats.size());
      	    			System.out.println(num);
      	    			
      	    			PassengerSeat[] match = new PassengerSeat[num];
      	    			int numberOfmatches = 0;
      	    			boolean found = false;
      	    			boolean[] reserved = new boolean[seats.size()];
      	    			for(int k=0;k<seats.size();k++)
      	    				reserved[k]=false;
      	    			boolean[] find = new boolean[num];
      	    			for(int k=0;k<num;k++)
      	    				find[k]=false;
      	    			
      	    			for(int k=0;k<seats.size();k++){
      	    				for(int m=0;m<num;m++){
      	    					if(!found){
	      	    					int comp = preferences[m].compareTo(seats.get(k).getType());
	      	    					if(comp==0){
	      	    						numberOfmatches++;
	      	    						match[m]=seats.get(k);
	      	    						find[m]=true;
	      	    						reserved[k]=true;
	      	    						found=true;
	      	    					}
      	    					}
      	    				}
      	    				found=false;
      	    			}
      	    			found=false;
      	    			for(int k=0;k<seats.size();k++){
      	    				for(int m=0;m<num;m++){
      	    				if(!found){
	      	    					if( (!find[m]) && (!reserved[k])){
	      	    						numberOfmatches++;
	      	    						match[m]=seats.get(k);
	      	    						find[m]=true;
	      	    						reserved[k]=true;
	      	    						found=true;
	      	    					}
      	    					}
      	    				}
      	    				found=false;
      	    			}
      	    		
      	    			for(int k=0;k<num;k++){
      	    				tempSeat.get(k).add(match[k]);
      	    			}
      	    		}
      	    	}
				
      	      }		
				
				
			} catch (SQLException e) {
				
				throw new Exception("Database error");
			}
			
			ArrayList<Passenger> resultPass = new ArrayList<Passenger>();
			for(int i=0;i<num;i++){
        		Passenger tempPass = new Passenger(book.getPassengers().get(i).getIDNumber(),book.getPassengers().get(i).getName(),
        					book.getPassengers().get(i).getPreferredSeat(),tempSeat.get(i));
        		resultPass.add(tempPass);
        	}
        	Booking resbook = new Booking(book.getTrip(),resultPass,book.getPaymentInfo());
        	return resbook; 
        }
        
        private ArrayList<PassengerSeat> getSeats(Connection con,int flightInstanceSN) throws SQLException{
        	PreparedStatement ps = con.prepareStatement(
                	"SELECT seat.row AS row, seat.position AS position, seat.type AS type, "+
                	"seatinstance.fk_flightinstanceSN AS flightinstanceSN "+
                	"FROM seat INNER JOIN seatinstance ON seat.ID=seatinstance.fk_seat "+
                	"WHERE seatinstance.empty=1 AND seatinstance.fk_flightinstanceSN=?;" );
        	ps.setInt(1, flightInstanceSN);
        	
        	ArrayList<PassengerSeat> list = new ArrayList<PassengerSeat>();
        	ResultSet rs = ps.executeQuery();
        	while (rs.next()) {
        		int row = rs.getInt("row");
        		char position = rs.getString("position").charAt(0);
        		String type = rs.getString("type");
        		PassengerSeat tmp = new PassengerSeat(row,position,type,flightInstanceSN);
        		list.add(tmp);
        	}
        	return list;
        }
        
        //Pre: true
        //Post: has returned the booking corresponding to the bookingID if valid
        //else exception is thrown
        public Booking searchBookingByID(int id) throws Exception
        {
                Booking b = null;
                //b = readDB.searchBookingByID(id); 
        
                if(b == null)
                        throw new Exception("Not found");
                else
                        return b;
                
        }
        
        //Pre: the booking b is a valid booking
        //Post: has deleted the booking 
        public boolean deleteBooking(Booking b) {
        
                try
                {
                //Fix sql
                //String sql = "DELETE BOOKING bla bla";
                //writeDB.write(sql);
                }
                catch(Exception e)
                {
                        return false;
                }
                return true;
        }
        
        //Pre: the booking b
        //Post: has made the booking
        public Booking makeBooking(Booking b) {
        	return null;
        }
        
        //Pre: payment information
        //Post: has returned true if payment information is valid
        public boolean validatePaymentInfo(PaymentInfo payInfo){
        	return true;
        }
}