package eu.trojanbug.spring.security.gae;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.ui.preauth.AbstractPreAuthenticatedProcessingFilter;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;

public class GoogleAccountsAuthenticationProcessingFilter extends
		AbstractPreAuthenticatedProcessingFilter {

	private static final Log logger = LogFactory
			.getLog(GoogleAccountsAuthenticationProcessingFilter.class);

	@Override
	protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
		return "N/A";
	}

	@Override
	protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
		UserService userService = UserServiceFactory.getUserService();
		User user = userService.getCurrentUser();
		if (logger.isDebugEnabled() && user!=null)
			logger.debug("Returning Google Accounts pre-authenticated user: "
					+ user.getEmail());
		return user;
	}

	@Override
	public int getOrder() {
		return 0;
	}

}
