import java.io.Serializable;
import java.util.ArrayList;

/**
 * Classe permettant de créer un avion
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.0
 */
public class Avion implements Serializable{
    private int capacite;
    private int numeroAvion;
    private ArrayList<Trajet> listeTrajet;

    
    /** 
     * Construit un avion
     * @param capacite capacité de l'avion
     * @param numeroAvion numéro de l'avion
     */
    public Avion(int capacite,int numeroAvion){
	setCapacite(capacite);
	setNumeroAvion(numeroAvion);
	listeTrajet = new ArrayList<Trajet>();
    }
    
    /**
     * Constructeur par défaut d'un avion comportement 10 places et le numéro 1111
     */
    public Avion() {
	this(10, 1111);
    }
    
    /**
     * Retourne la capacité de l'avion
     * @return capacité de l'avion
     */
    public int getCapacite(){
	return capacite;
    }

    /**
     * Retourne le numéro de l'avion
     * @return numéro de l'avion
     */
    public int getNumeroAvion(){
	return numeroAvion;
    }

    /**
     * Permet de définir une capacité
     * @param capacite capacité
     */
    public void setCapacite(int capacite){
	if( capacite > 0 ){
	    this.capacite = capacite;
	}
	else{
	    System.err.println("La capacité rentrée est négative !");
	}
    }

    /**
     * Permet de définir un numéro pour l'avion
     * @param numeroAvion numéro de l'avion
     */
    public void setNumeroAvion(int numeroAvion){
	if( numeroAvion > 0 ){
	    this.numeroAvion = numeroAvion;
	}
	else{
	    System.err.println("Le numéro d'avion rentré est négatif !");
	}
    }
    
    /**
     * Ajoute un trajet à la liste des trajets de l'avion
     * @param trajet trajet à ajouter 
     */
    public void addTrajet(Trajet trajet){
	listeTrajet.add(trajet);
    }

    /**
     * Retourne un trajet souhaité dans la liste des trajets de l'avion à l'aide de son index
     * @param index index du trajet souhaité
     */
    public Trajet getTrajet(int index){
	return listeTrajet.get(index);
    }
    
    /**
     * Retourne la liste des trajets
     * @return liste des trajets
     */
    public ArrayList<Trajet> getListeTrajet(){
	return listeTrajet;
    }
    
    /**
     * Retourne une chaîne de caractères décrivant un avion
     * @return chaîne de caractères décrivant un avion
     */
    public String toString() {
	String chaineFormat="Capacite: "+capacite +"\n"+"Numero avion: "+numeroAvion;;
	
	for(Trajet trajet: listeTrajet)
	    chaineFormat+=trajet+"\n";
	return chaineFormat;
    }

}