import org.jdom.output.*;
import java.util.*;
import java.io.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.filter.*;

/**
 * <code> Classe:AvionXml <br>permet relier les classes Avion et  AvionXml </code>.
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.0
 */

public class AvionXml {
    private ArrayList<Avion> listeAvion;
    private Document docVolXml;

    /**
     *<code> Constructeur: AvionXml <br>Créé  un fichier XML s'il n'existe, ou sinon créé une liste à partir du fichier XML</code>.
     */
    public AvionXml() {
	SAXBuilder sxb = new SAXBuilder();
	try{
	    docVolXml = sxb.build(new File("avions.xml"));
	}
	catch(Exception e){
	    docVolXml = new Document(new Element("avions"));		
	}
	Element racineAvion = docVolXml.getRootElement();
	List listeAv= racineAvion.getChildren("avion");
	listeAvion = new ArrayList<Avion> ();
	TrajetXml trajXml=new TrajetXml();
	
	Iterator iListeAv = listeAv.iterator();
	while(iListeAv.hasNext()) {
	    Element avionCourant=(Element)iListeAv.next();
	    int capacite=Integer.parseInt(avionCourant.getChildText("capacite"));
	    int numeroAvion=Integer.parseInt(avionCourant.getChildText("numeroavion"));
	    
	    Avion avion = new Avion(capacite,numeroAvion );
	    ArrayList <Trajet> listeTrajet=trajXml.remplirTrajet(avionCourant.getChild("trajets").getChildren());
	    for(Trajet trajet:listeTrajet)
		avion.addTrajet(trajet);
	    listeAvion.add(avion);
	    
	}
    }

    /**
     * <code>Méthode: enregistreAvionXml <br> permet d'enregistrer le contenu de la liste dans
     * le fichier XML dedié</code>.
     */
    public void enregistreAvionXml() {
	try {
		XMLOutputter fichierAvion = new XMLOutputter(Format.getPrettyFormat());
		fichierAvion.output(docVolXml, new FileOutputStream("avions.xml"));
	    }catch (java.io.IOException e){
	    System.out.println("Impossible de sauvegarder le fichier avions.xml."); 
	}
    }

    /**
     * <code>Méthode: enregistreAvion <br> permet d'enregistrer le contenu de la liste dans
     * le fichier XML dedié</code>.
     */
    public void enregistreAvion(ArrayList<Avion> liste) {
	this.listeAvion=liste;
	Iterator iListeAvion=listeAvion.iterator();

	while(iListeAvion.hasNext()) {
	    Element avion=new Element("avion");
	    Element trajets=new Element("trajets");
	    Element capacite=new Element("capacite");
	    Element numeroavion=new Element("numeroavion");
	    

	    
	    Avion avionCourant=(Avion)iListeAvion.next();

	    avion.addContent(capacite);
	    avion.addContent(numeroavion);
	    numeroavion.setText(String.valueOf(avionCourant.getNumeroAvion()));
	    capacite.setText(String.valueOf(avionCourant.getCapacite()));
	    
	    
	    for(Trajet trajetCourant : avionCourant.getListeTrajet()) {	
		Element trajet=new Element("trajet");
		Element numerovol=new Element("numerovol");
		Element nombredeplaceoccupees=new Element("nombredeplaceoccupees");
		Element datedepart=new Element("datedepart");
		Element datearrivee=new Element("datearrivee");	    
		Element villedepart=new Element("villedepart");
		Element villearrivee=new Element("villearrivee");
		Element prix=new Element("prix");
		
		trajet.addContent(numerovol);
		trajet.addContent(nombredeplaceoccupees);
		trajet.addContent(datedepart);	    
		trajet.addContent(datearrivee);
		trajet.addContent(villedepart);
		trajet.addContent(villearrivee);
		trajet.addContent(prix);
		
		numerovol.setText(String.valueOf(trajetCourant.getNumeroVol()));
		nombredeplaceoccupees.setText(String.valueOf(trajetCourant.getNombrePLacesOccupees()));
		datedepart.setText(trajetCourant.afficherDateDepart());
		datearrivee.setText(trajetCourant.afficherDateArrivee());
		villedepart.setText(trajetCourant.getVilleDepart());
		villearrivee.setText(trajetCourant.getVilleArrivee());
		prix.setText(String.valueOf(trajetCourant.getPrix()));
		trajets.addContent(trajet);
	    }
	    avion.addContent(trajets);
	    docVolXml.getRootElement().addContent(avion);			
	}
	enregistreAvionXml();
    }

    /**<code> Méthode: addAvion <br> ajoute un nouvel avion à la liste d'avion </code>
     * @param nouveauAvion <code> représente le nouvel avion </code>
     */
    public void addAvion(Avion nouveauAvion) {
	listeAvion.add(nouveauAvion);
    }
    
    /** <code> Méthode: toString  permet de lister tous les avions existants </code>
     *  @return <code> String  </code> 
     */
    public String toString() {
	String chaineFormat="";

	for(Avion avion: listeAvion) 
	    chaineFormat+=avion+"\n";
	return chaineFormat;
    }

}