//package gestionreservation;

import java.util.ArrayList;
import java.util.Scanner;
import java.io.*;

/**
 * Classe permettant de créer un serveur à partir d'une liste d'Avion
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.0
 */
public class Serveur implements Serializable{
    private String nom;
    private ArrayList<Avion> listeAvion;
    private ArrayList<Trajet> listeTousTrajets;
    
    /**
     * Construit un serveur
     * @param nom nom du serveur
     *
     */
    public Serveur(String nom){ // A completer
	this.nom = nom;
	listeAvion = new ArrayList<Avion>();
	listeTousTrajets = new ArrayList<Trajet>();
    }
    
    /**
     * Met a jour une liste comprenant tous les trajets de tous les avions
     */
    public void setListeTousTrajets(){
	for( int i = 0; i < listeAvion.size(); i++ ){
	    for( int j = 0; j < ((listeAvion.get(i)).getListeTrajet()).size(); j++ ){ 
		listeTousTrajets.add((listeAvion.get(i)).getTrajet(j));
	    }
	} 
    }
    
    /** Retourne un trajet voulu dans la liste de tous les trajets à partir de son index
     * @param i index du trajet dans la liste
     * @return trajet voulu dans la liste de tous les trajets
     */
    public Trajet getTrajet(int i){
	  return listeTousTrajets.get(i);
    }
    public String getNom() {
	return nom;
    }

    /** Retourne le toString() de tous les trajets
     * @return toString() de tous les trajets
     */
    public String afficherTousTrajets(){
	String affichage = "";
	for( int i = 0; i < listeTousTrajets.size(); i++ ){
	    affichage += listeTousTrajets.get(i) + "\n";
	}
	return affichage;
    }

    /** Retourne toutes les villes de départ sans répétition
     * @return toutes les villes de départ sans répétition
     */
    public String afficherVillesDeparts(){
	String affichage = "";
	for( int i = 0; i < listeTousTrajets.size(); i++ ){
	    if ( affichage.contains((listeTousTrajets.get(i)).getVilleDepart()) == false ){
		affichage += (listeTousTrajets.get(i)).getVilleDepart() + "\n";
	    }
	}
	return affichage;
    }

    /** Retourne toutes les villes d'arrivée sans répétion
     * @return toutes les villes d'arrivée sans répétition
     */
    public String afficherVillesArrivees(){
	String affichage = "";
	for( int i = 0; i < listeTousTrajets.size(); i++ ){
	    if ( affichage.contains((listeTousTrajets.get(i)).getVilleArrivee()) == false ){
		affichage += (listeTousTrajets.get(i)).getVilleArrivee() + "\n";
	    }
	}
	return affichage;
    }
    
    /** Ajouter un avion à la liste des avions, puis serialise l'objet Serveur
     * @param avion avion à ajouter
     */
    public void addAvion(Avion avion){
	listeAvion.add(avion);
	serialize();
    }

    public void addListAvion(ArrayList<Avion> liste){
	while(liste.iterator().hasNext())
	    listeAvion.add(liste.iterator().next());
    }
    
    /**
     * Supprime un avion de la liste des avions,puis serialise l'objet Serveur
     * @param avion avion à supprimer
     */
    public void supprimerAvion(Avion avion) {
	listeAvion.remove(avion);
	serialize();
    }

    /** 
     * Retourne un avion de la liste d'avions à partir de son index
     * @param index index de l'avion
     * @return avion de la liste d'avions à partir de son index
     */ 
    public Avion getAvion(int index) {
	return listeAvion.get(index);
    }
    
    /**
     * Retourne l'index de l'avion dans la liste des avions à partir de l'index dans la liste de tous les trajets
     * @param indexTrajet index de l'avion dans la liste de tous les trajets
     * @param index de l'avion dans la liste des avions à partir de l'index dans la liste de tous les trajets
     */
      public int getIndexAvion(int indexTrajet) {
	for( int i = 0; i < listeAvion.size(); i++ ){
	    for( int j = 0; j < ((listeAvion.get(i)).getListeTrajet()).size(); j++ ){
		if( (listeTousTrajets.get(indexTrajet)).equals((listeAvion.get(i)).getTrajet(j)) ){
		    return i;
		}	
	    }
	}
	return -1;
      }
    
    /**
     * Retourne l'index d'un trajet dans la liste totale des trajets à partir du numéro du vol
     * @param numeroVol numéro du vol
     * @return l'index d'un trajet dans la liste totale des trajets à partir du numéro du vol
     */
    public int getIndexTrajet(int numeroVol) {
	for(int i = 0; i < listeTousTrajets.size(); i++ ){
	    if ((listeTousTrajets.get(i)).getNumeroVol() == numeroVol ){
		return i;
	    }
	}
	    return -1;
    }
    
    /**
     * Retourne la liste des avions
     * @return liste des avions
     */
    public ArrayList<Avion> getListeAvion() {
	return listeAvion; 
    }
   
    /**
     * Méthode permettant de faire la recherche d'un vol, puis de lancer une réservation.
     */
    public void rechercher(){
	Scanner sc = new Scanner(System.in);
	System.out.println("Bienvenue dans la recherche de votre vol :\nVeuillez entrer la ville de départ souhaitée parmis la liste des villes suivantes :\n" + afficherVillesDeparts() + "\nVille de départ souhaitée :");
	String str = sc.nextLine();
	Scanner sc1 = new Scanner(System.in);
	System.out.println("\nVeuillez entrer la ville d'arrivée souhaitée parmis la liste des villes suivantes :\n" + afficherVillesArrivees() + "\nVille d'arrivée souhaitée :");
	String str1 = sc1.nextLine();
	Scanner sc2 = new Scanner(System.in);
	System.out.println("\nVeuillez entrer la date souhaitée de départ sous forme JJ/MM/AA :");
	String str2 = sc2.nextLine();
	Scanner sc3 = new Scanner(System.in);
	System.out.println("\nVeuillez entrer le nombre de passagers souhaité :");
	int int1 = sc3.nextInt();
	if( int1 <= 0 ){
	    System.out.println("Le nombre de passagers rentré est négatif ! La recherche est réinitialisée.");
	    rechercher();
	}
	String affichage = "";
	String numeros="";
	for( int i = 0; i < listeTousTrajets.size(); i++ ){
	    if( ((getTrajet(i)).getVilleDepart()).equals(str) && ((getTrajet(i)).getVilleArrivee()).equals(str1) && ((getTrajet(i)).getDateDepart()).equals(str2) && (listeAvion.get(getIndexAvion(i))).getCapacite() - (getTrajet(i)).getNombrePLacesOccupees() >= int1){
		affichage += "\n" + getTrajet(i);
		String numero = "";
		numeros += "\n" + numero.valueOf(getTrajet(i).getNumeroVol());
	    }
	}
	
	if( affichage.equals("") ){
	    System.out.println("\nAucun vol ne correspond à votre recherche, pour effectuer une nouvelle recherche veuillez taper -1, sinon veuillez taper un autre entier");
	    Scanner sc4 = new Scanner(System.in);
	    int int2 = sc4.nextInt();
	    if ( int2 == -1 ){
		rechercher();
	    }
	}
	else{
	    System.out.println("\nVoici la liste des vols correspondant à votre recherche :" + affichage + "\nVeuillez entrer le numéro du vol souhaité pour le reserver ou taper -1 pour annuler la réservation");
	    Scanner sc5 = new Scanner(System.in); 
	    int int3 = sc5.nextInt();
	    if( int3 == -1 ){
		System.out.println("Merci de votre visite, pour effectuer une nouvelle recherche, veuillez taper -1 sinon taper un autre entier");
		Scanner sc6 = new Scanner(System.in);
		int int4 = sc6.nextInt();
		if( int4 == -1 ){
		    rechercher();
		}
	    }
	    else{
		String entier = "";
		if( numeros.contains(entier.valueOf(int3)) == true ){
		    reservation(int3,int1);
		}
		else{
		    System.err.println("Le numéro du vol rentré ne fait pas partie de la liste précédente ! La réservation est réinitialisée\n");
		    rechercher();
		}
	    }
	}
    }
    
    /**
     * Permet de réserver un vol à partir du numéro du vol et du nombre de passagers souhaités.
     * Retourne une confirmation une console ainsi qu'une confirmation sous format HTML.
     * Précondition : l'utilisateur doit avoir installer Mozilla Firefox
     * @param i numéro du vol souhaité
     * @param k nombre de passagers souhaités
     */
    private void reservation(int i,int k){
	(listeTousTrajets.get(i)).ajouterXPlacesOccupees(k);
	System.out.println("\nPour confirmer votre réservation, veuillez rentrer votre nom de famille: ");
	Scanner sc6 = new Scanner(System.in);
	String str3 = sc6.nextLine();
	System.out.println("\nMerci de votre choix, voici la confirmation de votre vol : \n\n");
	System.out.println("Madame/Monsieur " + str3 + ", voici la confirmation de votre vol : " + "\n" +
	        "\n" +
		"---------------------------------------------------------------------" + "\n" +
		"| " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleDepart() + " - " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleArrivee() + "               " + k + " passager(s)" + "               " + (listeTousTrajets.get(getIndexTrajet(i))).getPrix() + " €" + "     |" + "\n" + 
		"|                                                                   |" + "\n" + 
		"| " + (listeTousTrajets.get(getIndexTrajet(i))).getHeureDepart() + "    " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleDepart() + "              " + "Vol N° : " + i + "                  " + (listeTousTrajets.get(getIndexTrajet(i))).getDateDepart() + " |" + "\n" +
		"| " + (listeTousTrajets.get(getIndexTrajet(i))).getHeureArrivee() + "    " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleArrivee() + "                                         " + (listeTousTrajets.get(getIndexTrajet(i))).getDateArrivee() + " |" + "\n" +
		"---------------------------------------------------------------------" + "\n");
	EcrireA("<!DOCTYPE html>" + "\n" +
		       "<html>" + "\n" +
		           "<head>" + "\n" +
		               "<meta charset=\"utf-8\" />" + "\n" +
		               "<title>Confirmation pour votre réservation</title>" + "\n" +
                           "</head>" + "\n" +
		       "\n" +
		           "<body>" + "\n" +
		                "<p>" + "\n" +
		"Madame/Monsieur " + str3 + ", voici la confirmation de votre vol : " + "</br>" + "\n" +
		"</br>" + "\n" +
		"--------------------------------------------------------------------------------------------------- </br>" + "\n" +
		"| " + "<strong>" + (listeTousTrajets.get(getIndexTrajet(i))).getVilleDepart() + " &nbsp - &nbsp " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleArrivee() + "</strong>" + " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp " + k + " passager(s)" + " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp " + (listeTousTrajets.get(getIndexTrajet(i))).getPrix() + " €" + " &nbsp &nbsp &nbsp &nbsp |" + "</br>" + "\n" + 
		"| &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp |" + "</br>" +
		"| " + (listeTousTrajets.get(getIndexTrajet(i))).getHeureDepart() + " &nbsp &nbsp " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleDepart() + " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp " + "Vol N° : " + i + " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp " + "<em>" + (listeTousTrajets.get(getIndexTrajet(i))).getDateDepart() + "</em>" + " |" + "</br>" + "\n" +
		"| " + (listeTousTrajets.get(getIndexTrajet(i))).getHeureArrivee() + " &nbsp &nbsp " + (listeTousTrajets.get(getIndexTrajet(i))).getVilleArrivee() + " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp " + "<em>" + (listeTousTrajets.get(getIndexTrajet(i))).getDateArrivee() + "</em>" + " |" + "</br>" +
		"---------------------------------------------------------------------------------------------------" + "\n" +
		                "</p>" + "\n" +
		           "</body>" + "\n" +
																											"</html>", "../reservation_"+str3);
	
	Runtime runtime = Runtime.getRuntime();
	try
	    {
		runtime.exec(new String[] {"firefox", "../reservation_"+str3});
	    }
	catch (IOException ex)
	    {
		ex.printStackTrace();
	    } 
		       
    }
    
    /** 
     * Ecrit un texte dans fichier à l'adresse voulue
     * @param texte texte que l'on veut écrire
     * @param adresse adresse du texte souhaitée
     */
    public void EcrireA(String texte, String adresse) {
	try
	    {
		
		FileWriter fw = new FileWriter(adresse,true); BufferedWriter output = new BufferedWriter(fw);
		output.write(texte+"\n");
		output.flush();
		output.close();

	    }
	catch(IOException ioe){
	    System.out.println("erreur : " + ioe );
	}

    } 
    
 
    /**
     *  <code>Méthode:serialize <br> permet de sérialiser, d'enregistrer, dans le fichier
     * ficReservation.dat l'Object de type serveur</code>
     */
    
    public void serialize() {
	try {
	    FileOutputStream fos = new FileOutputStream("ficReservation.serial");
	    ObjectOutputStream oos = new ObjectOutputStream(fos);
	    
	    oos.writeObject(this);
	    oos.flush();
	    oos.close();
	}catch(IOException ioe) {;} 
    }
    /**
     * <code>Méthode:deserialize <br>permet de lire dans le fichier ficReservation.dat 
     * un Serveur en l'occurence celui écrit par serialize </code>
     *@return Serveur <code> (objet serialliser) </code>
     * à return sous forme Serveur.
     */
    public Serveur deserialize() {
	Serveur serveur=null;
	
	try {
	    FileInputStream fis = new FileInputStream("ficReservation.serial");
	    ObjectInputStream ois = new ObjectInputStream(fis);
	    serveur=(Serveur)ois.readObject();
	}catch(Exception err) {
	    return null;
	}
	return serveur;
    }   
    
    /** <code> Méthode: toString d'afficher les informations sur le serveur </code>
     *  @return <code> String  </code> 
     */
    public String toString() {
	String chaineFormat="Nom:"+ nom;
	
	for(Avion avion:listeAvion) {
	    chaineFormat+=avion+"\n";
	}
	return chaineFormat;
    }
}