import org.jdom.output.*;
import java.util.*;
import java.io.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.filter.*;

/**
 * La classe ServeurXml permet de créer un fichier à partir d'une liste de serveur
 * ou bien de créer un liste de serveur à partir d'un fichier XML.
 * @author Guégan Frédéric & Diallo Mamadou Hady
 * @version 1.0
 */
public class ServeurXml {
    private ArrayList<Serveur> listeServeur;
    private Document servXml;

    /**
     *<code> Constructeur: ServeurXml <br>Créé  un fichier XML s'il n'existe, ou sinon créé une liste à partir du fichier XML</code>.
     */
    public ServeurXml() {
	SAXBuilder sxb = new SAXBuilder();
	try{
	    servXml = sxb.build(new File("serveurs.xml"));
	}
	catch(Exception e){
	    servXml = new Document(new Element("serveurs"));		
	}
	Element racineServeur = servXml.getRootElement();
	List listeServ=racineServeur.getChildren("serveur");
	listeServeur = new ArrayList<Serveur> ();
	TrajetXml trajXml=new TrajetXml();	
	Iterator iListeServ = listeServ.iterator();
	
	while(iListeServ.hasNext()){
	    Element serveurCourant=(Element)iListeServ.next();
	    String nom=serveurCourant.getChildText("nom");
	    Serveur serveur=new Serveur(nom);

	    List listeAv =serveurCourant.getChild("avions").getChildren("avion");
	    Iterator iListeAv = listeAv.iterator();
	    while(iListeAv.hasNext()) {
		Element avionCourant=(Element)iListeAv.next();
		int capacite=Integer.parseInt(avionCourant.getChildText("capacite"));
		int numeroAvion=Integer.parseInt(avionCourant.getChildText("numeroavion"));
		
		Avion avion = new Avion(capacite,numeroAvion );
		ArrayList <Trajet> listeTrajet=trajXml.remplirTrajet(avionCourant.getChild("trajets").getChildren());
		for(Trajet trajet:listeTrajet)
		    avion.addTrajet(trajet);
		
	    }
	    listeServeur.add(serveur);
	}
    }
    /**
     * <code>Méthode: enregistreServeurXml<br> enregistre les changements du fichier XMl dans un fichier specifié</code>.
     */
    public void enregistreServeurXml() {
	try {
		XMLOutputter fichierServeur = new XMLOutputter(Format.getPrettyFormat());
		fichierServeur.output(servXml, new FileOutputStream("serveur.xml"));
	    }catch (java.io.IOException e){
	    System.out.println("La sauvegarde du fichier serveur.xml a échoué."); 
	}
    }

    /**
     * <code>Méthode enregistreServeur <br> permet d'enregistrer le contenu de la liste dans
     * le fichier XML dedié</code>.
     */
    public void enregistreServeur() {
	Iterator iListeServeur=listeServeur.iterator();

	while(iListeServeur.hasNext()) { 
	    Element serveur=new Element("serveur");
	    Element nom=new Element("nom");
	    Element avions=new Element("avions");
	    Serveur  serveurCourant=(Serveur)iListeServeur.next();
	    serveur.addContent(nom);
	    nom.setText(serveurCourant.getNom());
	    ArrayList<Avion> listeAvion=serveurCourant.getListeAvion();
	    Iterator iListeAvion=listeAvion.iterator();
	    while(iListeAvion.hasNext()) {
		Element avion=new Element("avion");
		Element trajets=new Element("trajets");
		Element capacite=new Element("capacite");
		Element numeroavion=new Element("numeroavion");
	       
		Avion avionCourant=(Avion)iListeAvion.next();
		
		avion.addContent(capacite);
		avion.addContent(numeroavion);
		numeroavion.setText(String.valueOf(avionCourant.getNumeroAvion()));
		capacite.setText(String.valueOf(avionCourant.getCapacite()));
		
		
		for(Trajet trajetCourant : avionCourant.getListeTrajet()) {	
		    Element trajet=new Element("trajet");
		    Element numerovol=new Element("numerovol");
		    Element nombredeplaceoccupees=new Element("nombredeplaceoccupees");
		    Element datedepart=new Element("datedepart");
		    Element datearrivee=new Element("datearrivee");	    
		    Element heuredepart=new Element("heuredepart");
		    Element heurearrivee=new Element("heurearrivee");
		    Element villedepart=new Element("villedepart");
		    Element villearrivee=new Element("villearrivee");
		    Element prix=new Element("prix");
		    
		    trajet.addContent(numerovol);
		    trajet.addContent(nombredeplaceoccupees);
		    trajet.addContent(datedepart);	    
		    trajet.addContent(datearrivee);
		    trajet.addContent(heuredepart);
		    trajet.addContent(heurearrivee);
		    trajet.addContent(villedepart);
		    trajet.addContent(villearrivee);
		    trajet.addContent(prix);
		    
		    numerovol.setText(String.valueOf(trajetCourant.getNumeroVol()));
		    nombredeplaceoccupees.setText(String.valueOf(trajetCourant.getNombrePLacesOccupees()));
		    datedepart.setText(trajetCourant.getDateDepart());
		    datearrivee.setText(trajetCourant.getDateArrivee());
		    heuredepart.setText(trajetCourant.getHeureDepart());
		    heurearrivee.setText(trajetCourant.getHeureArrivee());
		    villedepart.setText(trajetCourant.getVilleDepart());
		    villearrivee.setText(trajetCourant.getVilleArrivee());
		    prix.setText(String.valueOf(trajetCourant.getPrix()));
		    trajets.addContent(trajet);
		}
		avion.addContent(trajets);
		avions.addContent(avion);
		}
	    serveur.addContent(avions);
	    servXml.getRootElement().addContent(serveur);			
	}
	
	enregistreServeurXml();
    }
    /**
     * <code>Méthode addAvionServeurXml<br> permet d'ajouter un avion dans le fichier XML<code>
     * @param Avion
     */
    public void addAvionServeurXml(Avion avionCourant) {
	Element serveur=new Element("serveur");
	Element avion=new Element("avion");
	Element trajets=new Element("trajets");
	Element capacite=new Element("capacite");
	Element numeroavion=new Element("numeroavion");
	
	avion.addContent(capacite);
	avion.addContent(numeroavion);
	numeroavion.setText(String.valueOf(avionCourant.getNumeroAvion()));
	capacite.setText(String.valueOf(avionCourant.getCapacite()));
	
	
	for(Trajet trajetCourant : avionCourant.getListeTrajet()) {	
	    Element trajet=new Element("trajet");
	    Element numerovol=new Element("numerovol");
	    Element nombredeplaceoccupees=new Element("nombredeplaceoccupees");
	    Element datedepart=new Element("datedepart");
	    Element datearrivee=new Element("datearrivee");	    
	    Element heuredepart=new Element("heuredepart");
	    Element heurearrivee=new Element("heurearrivee");
	    Element villedepart=new Element("villedepart");
	    Element villearrivee=new Element("villearrivee");
	    Element prix=new Element("prix");
	    
	    trajet.addContent(numerovol);
	    trajet.addContent(nombredeplaceoccupees);
	    trajet.addContent(datedepart);	    
	    trajet.addContent(datearrivee);
	    trajet.addContent(heuredepart);
	    trajet.addContent(heurearrivee);
	    trajet.addContent(villedepart);
	    trajet.addContent(villearrivee);
	    trajet.addContent(prix);
		    
	    numerovol.setText(String.valueOf(trajetCourant.getNumeroVol()));
	    nombredeplaceoccupees.setText(String.valueOf(trajetCourant.getNombrePLacesOccupees()));
	    datedepart.setText(trajetCourant.getDateDepart());
	    datearrivee.setText(trajetCourant.getDateArrivee());
	    heuredepart.setText(trajetCourant.getHeureDepart());
	    heurearrivee.setText(trajetCourant.getHeureArrivee());
	    villedepart.setText(trajetCourant.getVilleDepart());
	    villearrivee.setText(trajetCourant.getVilleArrivee());
	    prix.setText(String.valueOf(trajetCourant.getPrix()));
	    trajets.addContent(trajet);
	}

	Element racineServeur = servXml.getRootElement();
	List listeServ=racineServeur.getChildren("serveur");
	Element serv=(Element)listeServ.get(0);
	Element avions =serv.getChild("avions");
	avion.addContent(trajets);
	avions.addContent(avion);

	enregistreServeurXml();
    }
    /**<code> Méthode: addServeur <br> ajoute un nouveau serveur à la liste de serveur </code>
     * @param nouveauServeur <code> représente le nouveau serveur </code>
     */
    public void addServeur(Serveur nouveauServeur) {
	listeServeur.add(nouveauServeur);
    }
    
    /** <code> Méthode: toString  permet de lister tous les serveurs existants </code>
     *  @return <code> String  </code> 
     */
    public String toString() {
	String chaineFormat="";

	for(Serveur serv: listeServeur) 
	    chaineFormat+=serv+"\n";
	return chaineFormat;
    }
}