/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */




package demo.hello;

import java.io.*;
import org.omg.CORBA.*;
import org.omg.PortableServer.*;

public class Server {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java demo.hello.Server <ior_file>");
            System.exit(1);
        }
        try {
            //init ORB

            java.util.Properties props = new java.util.Properties();

            props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");

            ORB orb = ORB.init(args, props);
            //init POA
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            // create a GoodDay object
            HelloObjImpl impl = new HelloObjImpl(poa);
            // create the object reference
            org.omg.CORBA.Object obj = poa.servant_to_reference(impl);
//            org.omg.CORBA.Object obj = orb.binding("HelloServer", impl);
            PrintWriter pw = new PrintWriter(new FileWriter(args[0]));
            // print stringified object reference to file
            pw.println(orb.object_to_string(obj));
            pw.flush();
            pw.close();
            // wait for requests
            orb.run();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}
