/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */



package demo.nametest;

import java.io.*;
import org.omg.CORBA.*;
import org.omg.PortableServer.*;
import demo.hello.*;
import org.omg.CosNaming.*;

public class NameHelloServer {
    public static void main(String[] args) {

        try {
            //init ORB

            java.util.Properties props = new java.util.Properties();

            props.setProperty("org.omg.CORBA.ORBClass", "org.huihoo.orbas.orb.ORB");
            props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.huihoo.orbas.orb.ORBSingleton");

            ORB orb = ORB.init(args, props);
            //init POA
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            // create a GoodDay object
            HelloObjImpl impl = new HelloObjImpl(poa);
            // create the object reference
            org.omg.CORBA.Object obj = poa.servant_to_reference(impl);
            //Get the NameService
            org.omg.CORBA.Object objName = orb.resolve_initial_references("NameService");
            NamingContextExt context = NamingContextExtHelper.narrow(objName);
            //Set the HelloOjb a corba name to "demohello".
            NameComponent n = new NameComponent();
            n.id = "demohello";
            n.kind = "";
            NameComponent[] nc = new  NameComponent[1];
            nc[0] = n;
            //Bind the HelloObj to the Orbas NameService.
            context.bind(nc,obj);
            // wait for requests
            orb.run();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}
