package demo.value;

import java.io.*;

import org.omg.CORBA.*;
import org.omg.PortableServer.*;


public class Server
{
    public static void main(String[] args) 
    {
        if( args.length != 1 ) 
	{
            System.out.println(
                "Usage: java demo.value.Server <ior_file>");
            System.exit( 1 );
        }

        try 
        {            
            //init ORB
            java.util.Properties props = new java.util.Properties();

//            props.setProperty("org.omg.CORBA.ORBClass", "org.huihoo.orbas.orb.ORB");
//            props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.huihoo.orbas.orb.ORBSingleton");
            
            props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
 
//            org.huihoo.orbas.orb.ORB orb = (org.huihoo.orbas.orb.ORB)ORB.init(args, props);
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);
	    //init POA
	    POA poa = 
                POAHelper.narrow( orb.resolve_initial_references( "RootPOA" ));

	    poa.the_POAManager().activate();

            ValueServerImpl s = new ValueServerImpl();	
    
            // create the object reference
            org.omg.CORBA.Object obj = poa.servant_to_reference( s );

            PrintWriter pw = 
                new PrintWriter( new FileWriter( args[ 0 ] ));

            // print stringified object reference to file
            pw.println( orb.object_to_string( obj ));
            
            pw.flush();
            pw.close();
    
            // wait for requests
	    orb.run();
        }
        catch( Exception e ) 
        {
            System.out.println( e );
        }
    }
}
