/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class AddExpr extends IdlSymbol {
	public AddExpr add_expr = null;
	public String operator;
	public MultExpr mult_expr;

	public AddExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		if (add_expr != null) {
			add_expr.print(ps);
			ps.print(operator);
		}
		mult_expr.print(ps);
	}

	public void setDeclaration(ConstDecl declared_in) {
		mult_expr.setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		if (add_expr != null) {
			add_expr.setPackage(s);
		}
		mult_expr.setPackage(s);
	}

	public void parse() {
		if (add_expr != null) {
			add_expr.parse();
		}
		mult_expr.parse();
	}

	int pos_int_const() {
		int y = mult_expr.pos_int_const();
		if (add_expr != null) {
			int z = add_expr.pos_int_const();
			if (operator.equals("-"))
				z *= -1;
			return z + y;
		} else
			return y;
	}

	public String value() {
		String x = "";
		if (add_expr != null) {
			x = add_expr.value() + operator;
		}
		return x + mult_expr.value();
	}

	public String toString() {
		String x = "";
		if (add_expr != null) {
			x = add_expr + operator;
		}
		return x + mult_expr;
	}

	public str_token get_token() {
		return mult_expr.get_token();
	}
}
