/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class AndExpr extends IdlSymbol {

	public AndExpr and_expr = null;
	public ShiftExpr shift_expr;

	public AndExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		if (and_expr != null) {
			and_expr.print(ps);
			ps.print(" & ");
		}
		shift_expr.print(ps);
	}

	public void setDeclaration(ConstDecl declared_in) {
		shift_expr.setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;

		if (and_expr != null) {
			and_expr.setPackage(s);
		}
		shift_expr.setPackage(s);
	}

	public void parse() {
		if (and_expr != null) {
			and_expr.parse();
		}
		shift_expr.parse();
	}

	int pos_int_const() {
		return shift_expr.pos_int_const();
	}

	public String value() {
		String x = "";
		if (and_expr != null) {
			x = and_expr.value() + "&";
		}
		return x + shift_expr.value();
	}

	public String toString() {
		String x = "";
		if (and_expr != null) {
			x = and_expr + "&";
		}
		return x + shift_expr;
	}

	public str_token get_token() {
		return shift_expr.get_token();
	}

}
